/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.tag;

import com.jxdinfo.hussar.logic.exception.HussarLogicRegistryLookupException;
import com.jxdinfo.hussar.logic.generator.tag.LogicGenerateTag;
import com.jxdinfo.hussar.logic.generator.tag.LogicTagToleration;
import com.jxdinfo.hussar.logic.generator.utils.LogicGenerateTagUtils;
import com.jxdinfo.hussar.logic.structure.strategy.LogicTagLookupStrategy;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicTagTaintedResourceSet<T> {
    private static final Logger logger = LoggerFactory.getLogger(LogicTagTaintedResourceSet.class);
    private final Set<Element<T>> elements = ConcurrentHashMap.newKeySet();

    public void register(String[] taints, T resource) {
        Element<T> item = Element.from(taints, resource);
        this.elements.add(item);
    }

    public void register(List<LogicGenerateTag> taints, T resource) {
        Element<T> item = Element.from(taints, resource);
        this.elements.add(item);
    }

    public T lookup(LogicTagToleration toleration) {
        return this.lookup(toleration, null);
    }

    public T lookup(LogicTagToleration toleration, LogicTagLookupStrategy strategy) {
        return this.lookup(toleration, null, null);
    }

    public T lookup(LogicTagToleration toleration, Predicate<T> filter, LogicTagLookupStrategy strategy) {
        if (toleration == null) {
            throw new NullPointerException();
        }
        TreeSet<RankedElement<T>> candidates = new TreeSet<RankedElement<T>>();
        for (Element<T> element : this.elements) {
            int specificity = element.match(toleration);
            if (specificity < 0 || filter != null && !filter.test(element.getResource())) continue;
            candidates.add(RankedElement.of(specificity, element));
        }
        switch (strategy != null ? strategy : LogicTagLookupStrategy.MOST_SPECIFIED) {
            case SINGLE_OR_NONE: {
                if (candidates.size() == 0) {
                    return null;
                }
                if (candidates.size() == 1) {
                    return LogicTagTaintedResourceSet.getLastCandidate(candidates);
                }
                throw new HussarLogicRegistryLookupException("multiple candidates: " + candidates + ", lookup " + toleration);
            }
            case EXACTLY_SINGLE: {
                if (candidates.size() == 0) {
                    throw new HussarLogicRegistryLookupException("no candidates: lookup " + toleration);
                }
                if (candidates.size() == 1) {
                    return LogicTagTaintedResourceSet.getLastCandidate(candidates);
                }
                throw new HussarLogicRegistryLookupException("multiple candidates: " + candidates + ", lookup " + toleration);
            }
            case MOST_SPECIFIED: {
                if (candidates.size() == 0) {
                    throw new HussarLogicRegistryLookupException("no candidates: lookup " + toleration);
                }
                if (candidates.size() == 1) {
                    return LogicTagTaintedResourceSet.getLastCandidate(candidates);
                }
                int specificity = Optional.ofNullable(candidates.last()).map(RankedElement::getSpecificity).orElseThrow(NullPointerException::new);
                List topRankedCandidates = candidates.stream().filter(candidate -> candidate != null && candidate.getSpecificity() == specificity).collect(Collectors.toList());
                if (topRankedCandidates.size() == 1) {
                    logger.debug("multiple candidates without any ambiguity: {}", candidates);
                    return (T)Optional.ofNullable(topRankedCandidates.get(0)).map(RankedElement::getElement).map(Element::getResource).orElseThrow(NullPointerException::new);
                }
                throw new HussarLogicRegistryLookupException("multiple ambiguous candidates of specificity " + specificity + ": " + topRankedCandidates);
            }
        }
        throw new IllegalStateException();
    }

    private static <T> T getLastCandidate(NavigableSet<RankedElement<T>> candidates) {
        return (T)Optional.ofNullable(candidates.last()).map(RankedElement::getElement).map(Element::getResource).orElseThrow(NullPointerException::new);
    }

    private static final class RankedElement<T>
    implements Comparable<RankedElement<T>> {
        private final int specificity;
        private final Element<T> element;

        private RankedElement(int specificity, Element<T> element) {
            if (element == null) {
                throw new NullPointerException();
            }
            this.specificity = specificity;
            this.element = element;
        }

        public static <T> RankedElement<T> of(int specificity, Element<T> element) {
            return new RankedElement<T>(specificity, element);
        }

        public int getSpecificity() {
            return this.specificity;
        }

        public Element<T> getElement() {
            return this.element;
        }

        @Override
        public int compareTo(RankedElement<T> other) {
            return this.specificity - other.specificity;
        }

        public String toString() {
            List taints = Optional.of(this.element).map(Element::getTaintsIndex).map(LogicGenerateTagUtils::convertInternalIndexToTags).orElse(null);
            Object resource = Optional.of(this.element).map(Element::getResource).orElse(null);
            return "RankedElement{specificity=" + this.specificity + ", taints=" + taints + ", resource=" + resource + '}';
        }
    }

    private static final class Element<T> {
        private final Map<String, List<String>> taintsIndex;
        private final T resource;

        private Element(Map<String, List<String>> taintsIndex, T resource) {
            if (taintsIndex == null || resource == null) {
                throw new NullPointerException();
            }
            this.taintsIndex = taintsIndex;
            this.resource = resource;
        }

        public static <T> Element<T> from(String[] taints, T resource) {
            return new Element<T>(LogicGenerateTagUtils.convertTagsToInternalIndex(taints), resource);
        }

        public static <T> Element<T> from(List<LogicGenerateTag> taints, T resource) {
            return new Element<T>(LogicGenerateTagUtils.convertTagsToInternalIndex(taints), resource);
        }

        public int match(LogicTagToleration toleration) {
            if (toleration == null) {
                throw new NullPointerException();
            }
            int specificity = 0;
            for (Map.Entry<String, List<String>> taintsEntry : this.taintsIndex.entrySet()) {
                if (Objects.equals(taintsEntry.getKey(), "")) {
                    for (String tag : taintsEntry.getValue()) {
                        if (!toleration.tolerant("", tag)) {
                            return -1;
                        }
                        ++specificity;
                    }
                    continue;
                }
                if (taintsEntry.getValue() == null || taintsEntry.getValue().size() <= 0) continue;
                boolean anyMatch = false;
                for (String tag : taintsEntry.getValue()) {
                    if (!toleration.tolerant(taintsEntry.getKey(), tag)) continue;
                    anyMatch = true;
                    ++specificity;
                }
                if (anyMatch) continue;
                return -1;
            }
            return specificity;
        }

        public Map<String, List<String>> getTaintsIndex() {
            return this.taintsIndex;
        }

        public T getResource() {
            return this.resource;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Element element = (Element)other;
            return LogicGenerateTagUtils.internalIndexEquals(this.taintsIndex, element.taintsIndex) && Objects.equals(this.resource, element.resource);
        }

        public int hashCode() {
            return Objects.hash(LogicGenerateTagUtils.internalIndexHash(this.taintsIndex), this.resource);
        }
    }
}

