/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.tag;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class LogicGenerateTag {
    public static final String SEPARATOR = ":";
    private final String topic;
    private final String tag;

    private LogicGenerateTag(String topic, String tag) {
        if (tag == null) {
            throw new NullPointerException();
        }
        if (tag.contains(SEPARATOR) || StringUtils.isEmpty((CharSequence)tag)) {
            throw new IllegalArgumentException();
        }
        if (topic != null && (topic.contains(SEPARATOR) || StringUtils.isEmpty((CharSequence)topic))) {
            throw new IllegalArgumentException();
        }
        this.topic = topic;
        this.tag = tag;
    }

    public static LogicGenerateTag parse(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int index = value.indexOf(SEPARATOR);
        if (index < 0) {
            return LogicGenerateTag.of(null, value);
        }
        return LogicGenerateTag.of(value.substring(0, index), value.substring(index + SEPARATOR.length()));
    }

    public static LogicGenerateTag of(String topic, String tag) {
        return new LogicGenerateTag(topic, tag);
    }

    public String getTopic() {
        return this.topic;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LogicGenerateTag that = (LogicGenerateTag)other;
        return Objects.equals(this.topic, that.topic) && this.tag.equals(that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.tag);
    }

    public String toString() {
        return this.topic != null ? this.topic + SEPARATOR + this.tag : this.tag;
    }
}

