/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.service.impl;

import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateConfigureException;
import com.jxdinfo.hussar.logic.exception.HussarLogicRegistryLookupException;
import com.jxdinfo.hussar.logic.generator.holder.LogicGenerateProviderHolder;
import com.jxdinfo.hussar.logic.generator.provider.LogicGenerateProvider;
import com.jxdinfo.hussar.logic.generator.service.LogicGenerateService;
import com.jxdinfo.hussar.logic.generator.tag.LogicTagToleration;
import com.jxdinfo.hussar.logic.generator.utils.LogicGenerateTagUtils;
import com.jxdinfo.hussar.logic.properties.HussarLogicProperties;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateSource;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationFrontend;
import com.jxdinfo.hussar.logic.structure.strategy.LogicTagLookupStrategy;
import com.jxdinfo.hussar.logic.utils.LogicManualGcUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicGenerateServiceImpl
implements LogicGenerateService {
    private static final Logger logger = LoggerFactory.getLogger(LogicGenerateServiceImpl.class);
    private final HussarLogicProperties properties;

    @Autowired
    public LogicGenerateServiceImpl(HussarLogicProperties properties) {
        this.properties = properties;
    }

    public LogicGenerateResult generate(LogicGenerateSource source, LogicGenerateConfigure configure) {
        if (source == null || configure == null) {
            throw new NullPointerException();
        }
        configure = this.normalizeConfigure(configure);
        LogicTagToleration toleration = LogicGenerateTagUtils.getTolerationFromGenerateConfigure(configure);
        logger.debug("logic generate toleration tags: {}", (Object)toleration);
        LogicGenerateProvider provider = LogicGenerateProviderHolder.lookup(toleration, this.getProviderLookupStrategy());
        logger.debug("lookup logic generate provider: {}", (Object)toleration);
        if (provider == null) {
            throw new HussarLogicRegistryLookupException("no logic generate provider tolerates: " + toleration);
        }
        LogicGenerateResult result = provider.generate(source, configure);
        this.triggerGarbageCollection();
        return result;
    }

    private LogicGenerateConfigure normalizeConfigure(LogicGenerateConfigure configure) {
        LogicGenerateConfigure cfg;
        try {
            cfg = new LogicGenerateConfigure();
            BeanUtils.copyProperties((Object)cfg, (Object)configure);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new HussarLogicGenerateConfigureException("failed to duplicate configuration", ex);
        }
        if (cfg.getLanguage() == null) {
            throw new HussarLogicGenerateConfigureException("configure missing target language");
        }
        if (cfg.getPlatform() == null) {
            cfg.setPlatform(this.properties.getPlatform());
        }
        if (cfg.getRuntime() == null) {
            cfg.setRuntime(this.properties.getRuntime());
        }
        if (cfg.getFrontend() == null) {
            cfg.setFrontend(LogicGenerationFrontend.WEB_FRONTEND);
        }
        if (cfg.getVisitorLookupStrategy() == null) {
            cfg.setVisitorLookupStrategy(this.properties.getVisitorLookupStrategy());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.properties.getAdditionalTolerationTags())) {
            ArrayList additionalTolerationTags = new ArrayList(this.properties.getAdditionalTolerationTags());
            if (CollectionUtils.isNotEmpty((Collection)cfg.getAdditionalTolerationTags())) {
                additionalTolerationTags.addAll(cfg.getAdditionalTolerationTags());
            }
            cfg.setAdditionalTolerationTags(additionalTolerationTags);
        }
        if (cfg.getMaxSymbolAllocationRetry() == null) {
            cfg.setMaxSymbolAllocationRetry(this.properties.getMaxSymbolAllocationRetry());
        }
        return cfg;
    }

    private LogicTagLookupStrategy getProviderLookupStrategy() {
        return (LogicTagLookupStrategy)ObjectUtils.defaultIfNull((Object)this.properties.getProviderLookupStrategy(), (Object)LogicTagLookupStrategy.MOST_SPECIFIED);
    }

    private void triggerGarbageCollection() {
        if (this.properties.getAllowTriggerGc().booleanValue()) {
            LogicManualGcUtils.trigger();
        }
    }
}

