/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.render;

import com.jxdinfo.hussar.logic.generator.utils.LogicSlotPlaceholderUtils;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class LogicTemplateSlotDirective
implements TemplateDirectiveModel {
    public static final String NAME_PARAMETER = "name";
    public final boolean allowSourceMap;
    public final Map<String, LogicGeneratedCode> slots;

    public LogicTemplateSlotDirective(Map<String, LogicGeneratedCode> slots, boolean allowSourceMap) {
        this.slots = slots;
        this.allowSourceMap = allowSourceMap;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String nameValue;
        if (loopVars.length != 0) {
            throw new TemplateException("slot directive do not accept loop variables", env);
        }
        if (body != null) {
            throw new TemplateException("slot directive do not accept body", env);
        }
        if (!params.containsKey(NAME_PARAMETER)) {
            throw new TemplateException("slot directive missing name parameter", env);
        }
        if (params.size() != 1) {
            String redundant = params.keySet().stream().filter(key -> !Objects.equals(NAME_PARAMETER, key)).map(Object::toString).collect(Collectors.joining(", "));
            throw new TemplateException("slot directive do not accept redundant parameters: " + redundant, env);
        }
        TemplateModel nameParameter = (TemplateModel)params.get(NAME_PARAMETER);
        if (nameParameter instanceof TemplateScalarModel) {
            nameValue = ((TemplateScalarModel)nameParameter).getAsString();
            if (!LogicSlotPlaceholderUtils.isSlotNameValid(nameValue)) {
                throw new TemplateException("slot directive: invalid slot name: " + nameValue, env);
            }
            if (this.slots.get(nameValue) == null) {
                throw new TemplateException("slot directive: undefined slot name: " + nameValue, env);
            }
        } else {
            throw new TemplateException("slot directive: unsupported name parameter type: " + nameParameter.getClass(), env);
        }
        Writer out = env.getOut();
        if (this.allowSourceMap) {
            out.append(LogicSlotPlaceholderUtils.placeholderOf(nameValue));
        } else {
            LogicGeneratedCode slot = this.slots.get(nameValue);
            if (slot == null || slot.getCode() == null) {
                throw new TemplateException("slot directive: missing internal slot code for: " + nameValue, env);
            }
            out.append(slot.getCode());
        }
    }
}

