/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.render;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LogicTemplateReflectMethod
implements TemplateMethodModelEx {
    private final Object instance;
    private final Method target;

    public LogicTemplateReflectMethod(Object instance, Method target) {
        if (target == null) {
            throw new NullPointerException();
        }
        boolean staticMethod = Modifier.isStatic(target.getModifiers());
        if (!staticMethod && instance == null) {
            throw new IllegalArgumentException();
        }
        target.setAccessible(true);
        this.instance = staticMethod ? null : instance;
        this.target = target;
    }

    public static Map<String, LogicTemplateReflectMethod> reflect(Class<?> utils) {
        if (utils == null) {
            throw new NullPointerException();
        }
        LinkedHashMap<String, LogicTemplateReflectMethod> methods = new LinkedHashMap<String, LogicTemplateReflectMethod>();
        for (Method method : utils.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            String name = method.getName();
            if (methods.containsKey(name)) {
                throw new IllegalArgumentException("method overload is not supported: " + utils.getName() + "." + name + "(...)");
            }
            methods.put(name, new LogicTemplateReflectMethod(null, method));
        }
        return methods;
    }

    public static Map<String, LogicTemplateReflectMethod> reflect(Object bean) {
        if (bean == null) {
            throw new NullPointerException();
        }
        LinkedHashMap<String, LogicTemplateReflectMethod> methods = new LinkedHashMap<String, LogicTemplateReflectMethod>();
        for (Method method : bean.getClass().getMethods()) {
            String name = method.getName();
            if (methods.containsKey(name)) {
                throw new IllegalArgumentException("method overload or method name conflicted: " + bean.getClass().getName() + "." + name + "(...)");
            }
            if (Modifier.isStatic(method.getModifiers())) {
                methods.put(name, new LogicTemplateReflectMethod(null, method));
                continue;
            }
            methods.put(name, new LogicTemplateReflectMethod(bean, method));
        }
        return methods;
    }

    public Object exec(List arguments) throws TemplateModelException {
        try {
            return this.target.invoke(this.instance, arguments.toArray());
        }
        catch (InvocationTargetException ex) {
            throw new TemplateModelException(ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TemplateModelException(ex);
        }
    }
}

