/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.render;

import com.jxdinfo.hussar.CoreVersion;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateException;
import com.jxdinfo.hussar.logic.exception.HussarLogicRenderException;
import com.jxdinfo.hussar.logic.generator.context.LogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.render.LogicTemplateExceptionHandler;
import com.jxdinfo.hussar.logic.generator.render.LogicTemplateReflectMethod;
import com.jxdinfo.hussar.logic.generator.render.LogicTemplateSlotDirective;
import com.jxdinfo.hussar.logic.generator.utils.LogicSlotPlaceholderUtils;
import com.jxdinfo.hussar.logic.generator.utils.LogicTemplateBuiltinUtils;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.sourcemap.LogicSourceMap;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicRenderTemplate {
    private static final Logger logger = LoggerFactory.getLogger(LogicRenderTemplate.class);
    private static final String BUILTIN_PLATFORM_VERSION = "_platform_version";
    private static final String SLOT_DIRECTIVE = "slot";
    private static final String FALLBACK_METADATA = "_metadata";
    private static final String FALLBACK_CONFIGURE = "_configure";
    private static final String FALLBACK_COMPONENT = "_component";
    private static final String FALLBACK_PARAMETERS = "_params";
    private static final String FALLBACK_PROPS = "_props";
    private static final String FALLBACK_SLOTS = "_slots";
    private static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final int DEFAULT_TAB_SIZE = 4;
    private static final boolean DEFAULT_WHITESPACE_STRIPPING = true;
    private static final String DEFAULT_NUMBER_FORMAT = "computer";
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Map<String, Object> DEFAULT_BUILTINS = LogicRenderTemplate.createDefaultBuiltins();
    private final LogicGenerateContext context;
    private final LogicCanvasComponent component;
    private final Configuration configuration;
    private final Map<String, Object> builtins = new LinkedHashMap<String, Object>();
    private String owner;
    private String path;
    private Template template;
    private Map<String, Object> parameters;
    private Map<String, LogicGeneratedCode> slots;

    private LogicRenderTemplate(LogicGenerateContext context, LogicCanvasComponent component, Configuration configuration) {
        if (context == null || component == null || configuration == null) {
            throw new NullPointerException();
        }
        this.context = context;
        this.component = component;
        this.configuration = configuration;
        this.initialize();
    }

    private static Map<String, Object> createDefaultBuiltins() {
        LinkedHashMap<String, Object> builtins = new LinkedHashMap<String, Object>();
        builtins.put(BUILTIN_PLATFORM_VERSION, CoreVersion.getFrameworkVersion());
        try {
            builtins.putAll(LogicTemplateReflectMethod.reflect(LogicTemplateBuiltinUtils.class));
        }
        catch (IllegalArgumentException ex) {
            logger.warn("cannot load builtins from " + LogicTemplateBuiltinUtils.class.getSimpleName() + " using reflect", (Throwable)ex);
        }
        return builtins;
    }

    private void initialize() {
        this.owner = this.context.getCurrentSourceId();
        this.builtins.putAll(DEFAULT_BUILTINS);
    }

    public static LogicRenderTemplate begin(LogicGenerateContext context, LogicCanvasComponent component) {
        return new LogicRenderTemplate(context, component, LogicRenderTemplate.createDefaultConfiguration());
    }

    public static LogicRenderTemplate begin(LogicGenerateContext context, LogicCanvasComponent component, String templatePath) {
        return LogicRenderTemplate.begin(context, component).template(templatePath);
    }

    private static Configuration createDefaultConfiguration() {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
        configuration.setDefaultEncoding(DEFAULT_ENCODING);
        configuration.setTabSize(4);
        configuration.setWhitespaceStripping(true);
        configuration.setDateTimeFormat(DEFAULT_DATE_TIME_FORMAT);
        configuration.setNumberFormat(DEFAULT_NUMBER_FORMAT);
        configuration.setClassForTemplateLoading(LogicRenderTemplate.class, "/");
        configuration.setTemplateExceptionHandler((TemplateExceptionHandler)LogicTemplateExceptionHandler.INSTANCE);
        return configuration;
    }

    public LogicRenderTemplate configure(Consumer<Configuration> customizer) {
        customizer.accept(this.configuration);
        return this;
    }

    public LogicRenderTemplate builtins(Consumer<Map<String, Object>> customizer) {
        customizer.accept(this.builtins);
        return this;
    }

    public LogicRenderTemplate template(String path) {
        try {
            this.path = path;
            this.template = this.configuration.getTemplate(path);
            return this;
        }
        catch (IOException ex) {
            throw new HussarLogicRenderException("failed to load template", ex);
        }
    }

    public LogicRenderTemplate parameters(Map<String, Object> parameters) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        this.parameters.putAll(parameters);
        return this;
    }

    public LogicRenderTemplate parameter(String name, Object parameter) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, Object>();
        }
        this.parameters.put(name, parameter);
        return this;
    }

    public LogicRenderTemplate clearParameters() {
        this.parameters = null;
        return this;
    }

    public LogicRenderTemplate slots(Map<String, LogicGeneratedCode> slots) {
        if (this.slots == null) {
            this.slots = new LinkedHashMap<String, LogicGeneratedCode>();
        }
        this.slots.putAll(slots);
        return this;
    }

    public LogicRenderTemplate slot(String name, LogicGeneratedCode slot) {
        if (this.slots == null) {
            this.slots = new LinkedHashMap<String, LogicGeneratedCode>();
        }
        this.slots.put(name, slot);
        return this;
    }

    public LogicRenderTemplate clearSlots() {
        this.slots = null;
        return this;
    }

    public LogicGeneratedCode render() {
        String raw;
        if (this.template == null) {
            throw new IllegalStateException("no template loaded");
        }
        Map<String, Object> model = this.createDataModel();
        try (StringWriter out = new StringWriter();){
            this.template.process(model, (Writer)out);
            raw = ((Object)out).toString();
        }
        catch (TemplateException | IOException ex) {
            throw new HussarLogicRenderException("failed to process template: " + this.path, ex);
        }
        return this.postprocess(raw);
    }

    private boolean isAllowSourceMap() {
        return Optional.ofNullable(this.context).map(LogicGenerateContext::getConfigure).map(LogicGenerateConfigure::getAllowSourceMap).orElse(true);
    }

    private Map<String, Object> createDataModel() {
        Map props = this.component.getProps() != null ? this.component.getProps() : new LinkedHashMap();
        LinkedHashMap parameters = this.parameters != null ? this.parameters : new LinkedHashMap();
        LinkedHashMap<String, LogicGeneratedCode> slots = this.slots != null ? this.slots : new LinkedHashMap<String, LogicGeneratedCode>();
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        model.put(FALLBACK_CONFIGURE, this.context.getConfigure());
        model.put(FALLBACK_METADATA, this.context.getMetadata());
        model.put(FALLBACK_COMPONENT, this.component);
        model.put(FALLBACK_PARAMETERS, parameters);
        model.put(FALLBACK_PROPS, props);
        model.put(FALLBACK_SLOTS, slots);
        model.putAll(this.builtins);
        model.putAll(parameters);
        if (model.containsKey(SLOT_DIRECTIVE)) {
            logger.error("slot directive conflicted with user data {}", model.get(SLOT_DIRECTIVE));
        }
        LogicTemplateSlotDirective slotDirective = new LogicTemplateSlotDirective(slots, this.isAllowSourceMap());
        model.put(SLOT_DIRECTIVE, slotDirective);
        return model;
    }

    private LogicGeneratedCode postprocess(String raw) {
        if (!this.isAllowSourceMap()) {
            LogicGeneratedCode result = new LogicGeneratedCode();
            result.setCode(raw);
            return result;
        }
        StringBuilder codeBuilder = new StringBuilder();
        LogicSourceMap.Builder sourceMapBuilder = LogicSourceMap.Builder.of((String)this.owner);
        List<LogicSlotPlaceholderUtils.Segment> segments = LogicSlotPlaceholderUtils.parse(raw);
        for (LogicSlotPlaceholderUtils.Segment segment : segments) {
            if (segment.isPlaceholder()) {
                LogicGeneratedCode slot;
                String name = segment.getName();
                LogicGeneratedCode logicGeneratedCode = slot = this.slots != null ? this.slots.get(name) : null;
                if (slot == null) {
                    throw new HussarLogicGenerateException("slot reference name not defined: " + name);
                }
                if (slot.getCode() == null || slot.getSourceMap() == null) {
                    throw new HussarLogicGenerateException("slot missing code or source map: " + name);
                }
                codeBuilder.append(slot.getCode());
                sourceMapBuilder.add(slot.getSourceMap());
                continue;
            }
            String code = segment.getCode();
            codeBuilder.append(code);
            sourceMapBuilder.add(code);
        }
        LogicGeneratedCode result = new LogicGeneratedCode();
        result.setCode(codeBuilder.toString());
        result.setSourceMap(sourceMapBuilder.build());
        return result;
    }
}

