/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.jayway.jsonpath.TypeRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LogicJsonPathAccessible {
    public static final Logger JSON_PATH_ACCESSIBLE_LOGGER = LoggerFactory.getLogger(LogicJsonPathAccessible.class);

    public ReadContext getJsonPathContext();

    default public <T> T readJson(String path) {
        try {
            return (T)this.getJsonPathContext().read(path, new Predicate[0]);
        }
        catch (Exception ex) {
            JSON_PATH_ACCESSIBLE_LOGGER.warn("read json path '{}' failed", (Object)path, (Object)ex);
            return null;
        }
    }

    default public <T> T readJson(JsonPath path) {
        try {
            return (T)this.getJsonPathContext().read(path);
        }
        catch (Exception ex) {
            JSON_PATH_ACCESSIBLE_LOGGER.warn("read json path '{}' failed", (Object)path, (Object)ex);
            return null;
        }
    }

    default public <T> T readJson(String path, Class<T> clazz) {
        try {
            return (T)this.getJsonPathContext().read(path, clazz, new Predicate[0]);
        }
        catch (Exception ex) {
            JSON_PATH_ACCESSIBLE_LOGGER.warn("read json path '{}' and convert to {} failed", new Object[]{path, clazz, ex});
            return null;
        }
    }

    default public <T> T readJson(JsonPath path, Class<T> clazz) {
        try {
            return (T)this.getJsonPathContext().read(path, clazz);
        }
        catch (Exception ex) {
            JSON_PATH_ACCESSIBLE_LOGGER.warn("read json path '{}' and convert to {} failed", new Object[]{path, clazz, ex});
            return null;
        }
    }

    default public <T> T readJson(String path, TypeRef<T> typeRef) {
        try {
            return (T)this.getJsonPathContext().read(path, typeRef);
        }
        catch (Exception ex) {
            JSON_PATH_ACCESSIBLE_LOGGER.warn("read json path '{}' and convert to {} failed", new Object[]{path, typeRef.getType(), ex});
            return null;
        }
    }

    default public <T> T readJson(JsonPath path, TypeRef<T> typeRef) {
        try {
            return (T)this.getJsonPathContext().read(path, typeRef);
        }
        catch (Exception ex) {
            JSON_PATH_ACCESSIBLE_LOGGER.warn("read json path '{}' and convert to {} failed", new Object[]{path, typeRef.getType(), ex});
            return null;
        }
    }
}

