/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.holder;

import com.jxdinfo.hussar.logic.exception.HussarLogicRegistryLookupException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.tag.LogicTagTaintedResourceSet;
import com.jxdinfo.hussar.logic.generator.tag.LogicTagToleration;
import com.jxdinfo.hussar.logic.generator.visitor.LogicGenerateVisitor;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.strategy.LogicTagLookupStrategy;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public final class LogicGenerateVisitorHolder
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(LogicGenerateVisitorHolder.class);
    private static final Map<String, LogicTagTaintedResourceSet<LogicGenerateVisitor>> registry = new ConcurrentHashMap<String, LogicTagTaintedResourceSet<LogicGenerateVisitor>>();

    public static LogicGenerateVisitor lookup(LogicCanvasComponent component) {
        return LogicGenerateVisitorHolder.lookup(component, LogicTagToleration.DEFAULT, null);
    }

    public static LogicGenerateVisitor lookup(LogicCanvasComponent component, LogicTagToleration toleration) {
        return LogicGenerateVisitorHolder.lookup(component, toleration, LogicTagLookupStrategy.MOST_SPECIFIED);
    }

    public static LogicGenerateVisitor lookup(LogicCanvasComponent component, LogicTagToleration toleration, LogicTagLookupStrategy strategy) {
        String name = Optional.ofNullable(component).map(LogicCanvasComponent::getName).orElse(null);
        if (name == null) {
            throw new HussarLogicRegistryLookupException("component name is missing");
        }
        LogicTagTaintedResourceSet<LogicGenerateVisitor> resourceSet = registry.get(name);
        if (resourceSet == null) {
            throw new HussarLogicRegistryLookupException("no logic generate visitor for component: " + name);
        }
        return resourceSet.lookup(toleration, visitor -> visitor.filter(component), strategy);
    }

    public static void register(String component, String[] taints, LogicGenerateVisitor generateVisitor) {
        if (component == null || generateVisitor == null) {
            throw new NullPointerException();
        }
        registry.compute(component, (key, value) -> {
            if (value == null) {
                value = new LogicTagTaintedResourceSet<LogicGenerateVisitor>();
            }
            value.register(taints, generateVisitor);
            return value;
        });
        logger.debug("registered logic generate visitor {} for component type {}", generateVisitor.getClass(), (Object)component);
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map generateVisitors = applicationContext.getBeansOfType(LogicGenerateVisitor.class);
        logger.debug("discovered {} logic generate visitor candidates", (Object)generateVisitors.size());
        for (LogicGenerateVisitor generateVisitor : generateVisitors.values()) {
            LogicGenerateVisitorService visitorAnnotation = generateVisitor.getClass().getAnnotation(LogicGenerateVisitorService.class);
            if (visitorAnnotation == null) {
                logger.error("logic generate visitor {} is not annotated with @LogicGenerateVisitorService", generateVisitor.getClass());
                continue;
            }
            LogicGenerateVisitorHolder.register(visitorAnnotation.component(), visitorAnnotation.taints(), generateVisitor);
        }
    }
}

