/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.holder;

import com.jxdinfo.hussar.logic.exception.HussarLogicRegistryLookupException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateProviderService;
import com.jxdinfo.hussar.logic.generator.provider.LogicGenerateProvider;
import com.jxdinfo.hussar.logic.generator.provider.NamedLogicGenerateProvider;
import com.jxdinfo.hussar.logic.generator.tag.LogicTagTaintedResourceSet;
import com.jxdinfo.hussar.logic.generator.tag.LogicTagToleration;
import com.jxdinfo.hussar.logic.structure.strategy.LogicTagLookupStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public final class LogicGenerateProviderHolder
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(LogicGenerateProviderHolder.class);
    private static final Map<String, NamedLogicGenerateProvider> naming = new ConcurrentHashMap<String, NamedLogicGenerateProvider>();
    private static final LogicTagTaintedResourceSet<NamedLogicGenerateProvider> providers = new LogicTagTaintedResourceSet();

    public static LogicGenerateProvider lookup(String name) {
        NamedLogicGenerateProvider generateProvider = naming.get(name);
        if (generateProvider == null) {
            throw new HussarLogicRegistryLookupException("no logic generate provider of name: " + name);
        }
        return generateProvider;
    }

    public static LogicGenerateProvider lookup(LogicTagToleration toleration) {
        return LogicGenerateProviderHolder.lookup(toleration, LogicTagLookupStrategy.MOST_SPECIFIED);
    }

    public static LogicGenerateProvider lookup(LogicTagToleration toleration, LogicTagLookupStrategy strategy) {
        return providers.lookup(toleration, strategy);
    }

    public static synchronized void register(String name, String[] taints, LogicGenerateProvider generateProvider) {
        if (name == null || generateProvider == null) {
            throw new NullPointerException();
        }
        NamedLogicGenerateProvider namedGenerateProvider = NamedLogicGenerateProvider.of(name, generateProvider);
        NamedLogicGenerateProvider previousGenerateProvider = naming.putIfAbsent(name, namedGenerateProvider);
        if (previousGenerateProvider == null) {
            providers.register(taints, namedGenerateProvider);
            logger.debug("registered logic generate visitor {} of name {}", generateProvider.getClass(), (Object)name);
        } else {
            logger.error("conflicted logic generate provider of name {}: attempt to replace {} with {}", new Object[]{name, previousGenerateProvider.getTarget().getClass(), generateProvider.getClass()});
        }
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map generateProviders = applicationContext.getBeansOfType(LogicGenerateProvider.class);
        logger.debug("discovered {} logic generate providers", (Object)generateProviders.size());
        for (LogicGenerateProvider generateProvider : generateProviders.values()) {
            LogicGenerateProviderService providerAnnotation = generateProvider.getClass().getAnnotation(LogicGenerateProviderService.class);
            if (providerAnnotation == null) {
                logger.error("logic generate provider {} is not annotated with @LogicGenerateProviderService", generateProvider.getClass());
                continue;
            }
            LogicGenerateProviderHolder.register(providerAnnotation.name(), providerAnnotation.taints(), generateProvider);
        }
    }
}

