/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.context;

import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateContextException;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateException;
import com.jxdinfo.hussar.logic.exception.HussarLogicRegistryLookupException;
import com.jxdinfo.hussar.logic.generator.context.LogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.holder.LogicGenerateVisitorHolder;
import com.jxdinfo.hussar.logic.generator.render.LogicRenderTemplate;
import com.jxdinfo.hussar.logic.generator.tag.LogicTagToleration;
import com.jxdinfo.hussar.logic.generator.utils.LogicGenerateTagUtils;
import com.jxdinfo.hussar.logic.generator.visitor.LogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.arguments.LogicGenerateArguments;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.metadata.LogicMetadata;
import com.jxdinfo.hussar.logic.structure.strategy.LogicTagLookupStrategy;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogicGenerateContext
implements LogicGenerateContext {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLogicGenerateContext.class);
    protected final LogicMetadata metadata;
    protected final LogicGenerateConfigure configure;
    protected final LogicCanvasComponent root;
    protected final Map<String, LogicCanvasComponent> componentKeyIndex = new LinkedHashMap<String, LogicCanvasComponent>();
    protected final LogicTagToleration toleration;
    protected final Deque<LogicCanvasComponent> componentStack = new ArrayDeque<LogicCanvasComponent>();
    protected final Deque<LogicGenerateVisitor> visitorStack = new ArrayDeque<LogicGenerateVisitor>();

    public AbstractLogicGenerateContext(LogicMetadata metadata, LogicGenerateConfigure configure, LogicCanvasComponent root) {
        if (metadata == null || configure == null || root == null) {
            throw new NullPointerException();
        }
        this.metadata = metadata;
        this.configure = configure;
        this.root = root;
        this.toleration = LogicGenerateTagUtils.getTolerationFromGenerateConfigure(configure);
        this.initialize();
    }

    protected void initialize() {
        this.initializeComponentKeyIndex(this.root);
    }

    private void initializeComponentKeyIndex(LogicCanvasComponent component) {
        LogicCanvasComponent previous;
        String instanceKey = component.getInstanceKey();
        if (StringUtils.isEmpty((CharSequence)instanceKey)) {
            logger.warn("component missing instance key");
        }
        if ((previous = this.componentKeyIndex.put(instanceKey, component)) != null) {
            logger.warn("component instance key duplicated: {} <=> {}", (Object)component, (Object)previous);
        }
        if (MapUtils.isNotEmpty((Map)component.getSlots())) {
            for (List slot : component.getSlots().values()) {
                if (CollectionUtils.isEmpty((Collection)slot)) continue;
                for (LogicCanvasComponent child : slot) {
                    if (child == null) continue;
                    this.initializeComponentKeyIndex(child);
                }
            }
        }
    }

    @Override
    public LogicMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public LogicGenerateConfigure getConfigure() {
        return this.configure;
    }

    @Override
    public LogicTagToleration getToleration() {
        return this.toleration;
    }

    @Override
    public LogicGeneratedCode generate(LogicCanvasComponent component, Object ... arguments) {
        if (component == null) {
            throw new NullPointerException();
        }
        LogicGenerateVisitor visitor = LogicGenerateVisitorHolder.lookup(component, this.toleration, this.getVisitorLookupStrategy());
        if (visitor == null) {
            throw new HussarLogicRegistryLookupException("no logic generate visitor for component: " + component.getName());
        }
        LogicGenerateArguments visitorArguments = this.createGenerateArguments(arguments);
        try {
            this.componentStack.addLast(component);
            this.visitorStack.addLast(visitor);
            LogicGeneratedCode logicGeneratedCode = visitor.generate(this, component, visitorArguments);
            return logicGeneratedCode;
        }
        catch (HussarLogicGenerateException ex) {
            if (ex.getVisitorStack() == null) {
                ex.setVisitorStack(this.getStackTrace());
            }
            throw ex;
        }
        catch (Exception ex) {
            HussarLogicGenerateException exception = new HussarLogicGenerateException(ex);
            exception.setVisitorStack(this.getStackTrace());
            throw exception;
        }
        finally {
            this.componentStack.removeLast();
            this.visitorStack.removeLast();
        }
    }

    protected abstract LogicGenerateArguments createGenerateArguments(Object ... var1);

    @Override
    public LogicCanvasComponent getCurrentComponent() {
        return this.componentStack.peekLast();
    }

    @Override
    public LogicCanvasComponent getRootComponent() {
        return this.root;
    }

    @Override
    public LogicCanvasComponent getComponentByKey(String instanceKey) {
        return this.componentKeyIndex.get(instanceKey);
    }

    @Override
    public String getCurrentSourceId() {
        LogicCanvasComponent component = Optional.ofNullable(this.getCurrentComponent()).orElseGet(this::getRootComponent);
        return Optional.ofNullable(component).map(LogicCanvasComponent::getInstanceKey).filter(StringUtils::isNotEmpty).orElseThrow(() -> new HussarLogicGenerateContextException("failed to get current source id"));
    }

    protected List<String> getStackTrace() {
        ArrayList<String> stackTrace = new ArrayList<String>();
        Iterator<LogicCanvasComponent> componentIterator = this.componentStack.iterator();
        Iterator<LogicGenerateVisitor> visitorIterator = this.visitorStack.iterator();
        while (componentIterator.hasNext() && visitorIterator.hasNext()) {
            LogicCanvasComponent component = componentIterator.next();
            LogicGenerateVisitor visitor = visitorIterator.next();
            String componentName = StringUtils.removeStart((String)component.getName(), (String)"com.jxdinfo.logic.");
            String instanceKey = component.getInstanceKey();
            String visitorClass = visitor.getClass().getSimpleName();
            stackTrace.add(visitorClass + '@' + componentName + ':' + instanceKey);
        }
        return stackTrace;
    }

    @Override
    public LogicRenderTemplate beginTemplate(String templatePath) {
        return LogicRenderTemplate.begin(this, this.getCurrentComponent(), templatePath);
    }

    @Override
    public LogicGeneratedCode getCodeFragment(String code) {
        boolean allowSourceMap = Optional.ofNullable(this.configure.getAllowSourceMap()).orElse(true);
        String sourceId = allowSourceMap ? (String)Validate.notNull((Object)this.getCurrentSourceId(), (String)"missing source id", (Object[])new Object[0]) : null;
        return LogicGeneratedCode.byCode(sourceId, code);
    }

    protected LogicTagLookupStrategy getVisitorLookupStrategy() {
        return Optional.ofNullable(this.configure.getVisitorLookupStrategy()).orElse(LogicTagLookupStrategy.MOST_SPECIFIED);
    }
}

