/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.builder;

import com.jxdinfo.hussar.logic.structure.definition.LogicMethodSignatureDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicVariableDefinition;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public final class LogicMethodSignatureBuilder {
    private static final Pattern METHOD_OR_VAR_NAME_PATTERN = Pattern.compile("^[a-z_$][a-zA-Z0-9_$]*$");
    private final String name;
    private boolean async;
    private String title;
    private String description;
    private Map<String, LogicVariableDefinition> parameters;
    private LogicVariableDefinition result;

    private LogicMethodSignatureBuilder(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!METHOD_OR_VAR_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public static LogicMethodSignatureBuilder of(String name) {
        return new LogicMethodSignatureBuilder(name);
    }

    public LogicMethodSignatureBuilder async(boolean async) {
        this.async = async;
        return this;
    }

    public LogicMethodSignatureBuilder title(String title) {
        this.title = title;
        return this;
    }

    public LogicMethodSignatureBuilder description(String description) {
        this.description = description;
        return this;
    }

    public LogicMethodSignatureBuilder parameter(String name, LogicType type) {
        if (name == null || type == null) {
            throw new NullPointerException();
        }
        LogicVariableDefinition parameter = new LogicVariableDefinition();
        parameter.setName(name);
        parameter.setType(type);
        return this.parameter(parameter);
    }

    public LogicMethodSignatureBuilder parameter(LogicVariableDefinition parameter) {
        LogicVariableDefinition previous;
        if (parameter == null || parameter.getName() == null || parameter.getType() == null) {
            throw new NullPointerException();
        }
        if (!METHOD_OR_VAR_NAME_PATTERN.matcher(parameter.getName()).matches()) {
            throw new IllegalArgumentException("bad parameter name: " + parameter.getName());
        }
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, LogicVariableDefinition>();
        }
        if ((previous = this.parameters.putIfAbsent(parameter.getName(), parameter)) != null) {
            throw new IllegalArgumentException("duplicated parameter name: " + parameter.getName());
        }
        return this;
    }

    public LogicMethodSignatureBuilder parameters(List<LogicVariableDefinition> parameters) {
        this.parameters = null;
        for (LogicVariableDefinition parameter : Optional.ofNullable(parameters).orElse(Collections.emptyList())) {
            this.parameter(parameter);
        }
        return this;
    }

    public LogicMethodSignatureBuilder result(LogicType type) {
        if (type != null) {
            LogicVariableDefinition result = new LogicVariableDefinition();
            result.setType(type);
            this.result(result);
        } else {
            this.result = null;
        }
        return this;
    }

    public LogicMethodSignatureBuilder result(String name, LogicType type) {
        if (type != null) {
            LogicVariableDefinition result = new LogicVariableDefinition();
            result.setName(name);
            result.setType(type);
            this.result(result);
        } else {
            this.result = null;
        }
        return this;
    }

    public LogicMethodSignatureBuilder result(LogicVariableDefinition result) {
        if (result == null) {
            this.result = null;
            return this;
        }
        if (result.getType() == null) {
            throw new NullPointerException();
        }
        if (result.getName() != null && !METHOD_OR_VAR_NAME_PATTERN.matcher(result.getName()).matches()) {
            throw new IllegalArgumentException("bad result variable name: " + result.getName());
        }
        this.result = result;
        return this;
    }

    public LogicMethodSignatureDefinition build() {
        LogicMethodSignatureDefinition method = new LogicMethodSignatureDefinition();
        method.setName(this.name);
        method.setAsync(this.async);
        method.setTitle(this.title);
        method.setDescription(this.description);
        method.setParameters((List<LogicVariableDefinition>)(this.parameters != null ? new ArrayList<LogicVariableDefinition>(this.parameters.values()) : null));
        method.setResult(this.result);
        return method;
    }
}

