/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.structure.resolve.type;

import com.jxdinfo.hussar.logic.structure.resolve.type.JavaActualType;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaVoidType;

public final class JavaArrayType
implements JavaActualType {
    private final JavaActualType elementType;

    private JavaArrayType(JavaActualType elementType) {
        if (elementType == null) {
            throw new NullPointerException();
        }
        if (elementType.getClass() == JavaVoidType.class) {
            throw new IllegalArgumentException("cannot construct array of void");
        }
        this.elementType = elementType;
    }

    public static JavaArrayType of(JavaActualType elementType) {
        return new JavaArrayType(elementType);
    }

    @Override
    public String getName() {
        return this.getElementType().getName() + "[]";
    }

    @Override
    public boolean isSameType(JavaActualType other) {
        return other instanceof JavaArrayType && this.getElementType().isSameType(((JavaArrayType)other).getElementType());
    }

    public JavaActualType getElementType() {
        return this.elementType;
    }

    public String toString() {
        return this.getName();
    }
}

