/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.facade.simple.debug;

import com.jxdinfo.hussar.logic.engine.api.DebugLogicRuntime;
import com.jxdinfo.hussar.logic.engine.bean.DebugResult;
import com.jxdinfo.hussar.logic.engine.facade.log.DebugLogger;
import com.jxdinfo.hussar.logic.engine.facade.log.MessageConverter;
import com.jxdinfo.hussar.logic.engine.facade.simple.LogicRuntimeUtil;
import com.jxdinfo.hussar.logic.engine.facade.simple.SimpleLogicRuntime;
import com.jxdinfo.hussar.logic.engine.toolkit.ReflectUtilEx;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.event.Level;

public class DebugLogicRuntimeImpl
extends SimpleLogicRuntime
implements DebugLogicRuntime {
    protected DebugLogger logger = new DebugLogger();
    protected ExecutorService executor = Executors.newSingleThreadExecutor();
    private int maxDebugTime = 60;

    public DebugResult compileAndDebug(String script, String className, Level lvl, Object ... args) {
        Class clz;
        DebugResult rlt = new DebugResult();
        try {
            clz = this.engine.compile(script, className, true);
        }
        catch (Exception e) {
            rlt.setStdErr(e.getMessage());
            return rlt;
        }
        return this.debug(clz, lvl, args);
    }

    public DebugResult compileAndDebugWithConvert(String script, String className, Level lvl, Object ... args) {
        Class clz;
        DebugResult rlt = new DebugResult();
        try {
            clz = this.engine.compile(script, className, false);
        }
        catch (Exception e) {
            rlt.setStdErr(e.getMessage());
            return rlt;
        }
        return this.debug(clz, lvl, LogicRuntimeUtil.convertParams(ReflectUtilEx.getMethod((Class)clz, (String)"invoke"), args));
    }

    public void reset() {
        this.getLogger().clear();
        this.getEngine().unloadAll();
    }

    @Override
    protected void beforeInvoke(Object inst) {
        ReflectUtilEx.setFieldVal((Object)inst, (String)"runtime", (Object)this);
        ReflectUtilEx.setFieldVal((Object)inst, (String)"logger", (Object)((Object)this.logger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DebugResult debug(Class clz, Level lvl, Object ... args) {
        this.logger.setLevel(lvl);
        DebugResult rlt = new DebugResult();
        Object re = null;
        Future<Object> future = this.executor.submit(() -> {
            Object inst = ReflectUtilEx.newInstance((Class)clz);
            this.beforeInvoke(inst);
            return ReflectUtilEx.invoke((Object)inst, (String)"invoke", (Object[])args);
        });
        try {
            re = future.get(this.maxDebugTime, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            rlt.setStdErr(e.getMessage());
        }
        catch (ExecutionException e) {
            rlt.setStdErr(MessageConverter.convertThrowable(e));
        }
        catch (TimeoutException e) {
            rlt.setStdErr("\u6267\u884c\u8d85\u65f6");
        }
        finally {
            future.cancel(true);
        }
        if (re != null) {
            rlt.setReturnVal(re);
        }
        rlt.setStdOutput(this.logger.getOutput());
        return rlt;
    }

    public int getMaxDebugTime() {
        return this.maxDebugTime;
    }

    public void setMaxDebugTime(int maxDebugTime) {
        this.maxDebugTime = maxDebugTime;
    }

    public DebugLogger getLogger() {
        return this.logger;
    }

    public void setLogger(DebugLogger logger) {
        this.logger = logger;
    }
}

