/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.facade.simple;

import com.fasterxml.jackson.databind.JavaType;
import com.jxdinfo.hussar.logic.engine.ResourceFileLoader;
import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.api.UnloadableScriptEngine;
import com.jxdinfo.hussar.logic.engine.facade.simple.SimpleLogicRuntime;
import com.jxdinfo.hussar.logic.engine.groovy.GroovyUnloadedScriptEngine;
import com.jxdinfo.hussar.logic.engine.groovy.ResourceLoaderAdaptor;
import com.jxdinfo.hussar.logic.engine.groovy.UnloadableGroovyClassLoader;
import com.jxdinfo.hussar.logic.engine.janino.JaninoUnloadedScriptEngine;
import com.jxdinfo.hussar.logic.engine.janino.ResourceFinderAdaptor;
import com.jxdinfo.hussar.logic.engine.janino.UnloadedJaninoClassLoader;
import com.jxdinfo.hussar.logic.engine.toolkit.ReflectUtilEx;
import com.jxdinfo.hussar.logic.utils.LogicJsonUtils;
import groovy.lang.GroovyResourceLoader;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import org.codehaus.commons.compiler.util.resource.ResourceFinder;

public class LogicRuntimeUtil {
    private static LogicRuntime logicRuntime;

    public static <T> T run(String className, Object ... args) {
        LogicRuntimeUtil.assertState();
        return (T)logicRuntime.run(className, args);
    }

    public static Object[] convertArgs(String className, Object[] params) {
        LogicRuntimeUtil.assertState();
        return LogicRuntimeUtil.convertArgs(className, params, logicRuntime);
    }

    public static Object[] convertArgs(String className, Object[] params, LogicRuntime runtime) {
        try {
            Class clz = runtime.getEngine().loadClass(className);
            Method method = ReflectUtilEx.getMethod((Class)clz, (String)"invoke");
            return LogicRuntimeUtil.convertParams(method, params);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object[] convertParams(Method method, Object[] params) {
        LogicJsonUtils.JsonUtilsBean jsonUtils = LogicJsonUtils.createUtilsBean();
        Parameter[] parameters = method.getParameters();
        Object[] arguments = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            JavaType type = jsonUtils.getTypeFactory().constructType(parameters[i].getParameterizedType());
            arguments[i] = jsonUtils.convert(params[i], type);
        }
        return arguments;
    }

    public static LogicRuntime getInstance() {
        LogicRuntimeUtil.assertState();
        return logicRuntime;
    }

    public static void setInstance(LogicRuntime instance) {
        logicRuntime = instance;
    }

    private static void assertState() {
        if (logicRuntime != null) {
            return;
        }
        LogicRuntimeUtil.init();
    }

    private static synchronized void init() {
        if (logicRuntime != null) {
            return;
        }
        logicRuntime = LogicRuntimeUtil.getRuntime(LogicRuntimeUtil.getJaninoEngine());
    }

    private static SimpleLogicRuntime getRuntime(UnloadableScriptEngine engine) {
        SimpleLogicRuntime runtime = new SimpleLogicRuntime();
        runtime.setEngine(LogicRuntimeUtil.getJaninoEngine());
        return runtime;
    }

    private static UnloadableScriptEngine getGroovyEngine() {
        GroovyUnloadedScriptEngine engine = new GroovyUnloadedScriptEngine();
        UnloadableGroovyClassLoader classLoader = engine.getDefaultClassLoader();
        classLoader.setResourceLoader((GroovyResourceLoader)new ResourceLoaderAdaptor((ResourceLoader)new ResourceFileLoader()));
        return engine;
    }

    private static UnloadableScriptEngine getJaninoEngine() {
        JaninoUnloadedScriptEngine engine = new JaninoUnloadedScriptEngine();
        UnloadedJaninoClassLoader loader = engine.getDefaultClassLoader();
        loader.setSourceFinder((ResourceFinder)new ResourceFinderAdaptor((ResourceLoader)new ResourceFileLoader()));
        loader.setSourceCharset(StandardCharsets.UTF_8);
        return engine;
    }
}

