/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.facade.log;

import com.jxdinfo.hussar.platform.core.utils.ExceptionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.List;
import org.slf4j.helpers.FormattingTuple;

public class MessageConverter {
    public static final Object[] EMPTY_ARRAY = new Object[0];

    public static String convert(FormattingTuple tuple) {
        StringBuilder sb = new StringBuilder();
        boolean hasMsg = StringUtil.isNotEmpty((Object)tuple.getMessage());
        if (hasMsg) {
            sb.append(tuple.getMessage());
        }
        if (tuple.getThrowable() == null) {
            return sb.toString();
        }
        sb.append('\n');
        sb.append(MessageConverter.convertThrowable(tuple.getThrowable()));
        return sb.toString();
    }

    public static String convertThrowable(Throwable throwable) {
        return MessageConverter.rootThrowable(throwable);
    }

    private static String pathThrowable(Throwable throwable) {
        List ts = ExceptionUtil.getThrowableList((Throwable)throwable);
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Throwable t : ts) {
            if (isFirst) {
                sb.append(t.getMessage());
                isFirst = false;
                continue;
            }
            sb.append('\n').append("caused by:").append(t.getMessage());
        }
        return sb.toString();
    }

    private static String rootThrowable(Throwable throwable) {
        return ExceptionUtil.getRootCause((Throwable)throwable).getMessage();
    }
}

