/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.facade.log;

import com.jxdinfo.hussar.logic.engine.facade.log.MessageConverter;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class DebugLogger
extends MarkerIgnoringBase
implements Logger {
    private final Queue<String> logs = new ConcurrentLinkedQueue<String>();
    private Level level;

    public String getOutput() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> ls = new ArrayList<String>(this.logs);
        boolean isFirst = true;
        for (String l : ls) {
            if (!isFirst) {
                sb.append('\n');
            } else {
                isFirst = false;
            }
            sb.append(l);
        }
        return sb.toString();
    }

    public void clear() {
        this.logs.clear();
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public boolean isTraceEnabled() {
        return this.isEnalbed(Level.TRACE);
    }

    public void trace(String s) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY));
    }

    public void trace(String s, Object o) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o));
    }

    public void trace(String s, Object o, Object o1) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void trace(String s, Object ... objects) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)objects));
    }

    public void trace(String s, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY, (Throwable)throwable));
    }

    public boolean isDebugEnabled() {
        return this.isEnalbed(Level.DEBUG);
    }

    public void debug(String s) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY));
    }

    public void debug(String s, Object o) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o));
    }

    public void debug(String s, Object o, Object o1) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void debug(String s, Object ... objects) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)objects));
    }

    public void debug(String s, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY, (Throwable)throwable));
    }

    public boolean isInfoEnabled() {
        return this.isEnalbed(Level.INFO);
    }

    public void info(String s) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY));
    }

    public void info(String s, Object o) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o));
    }

    public void info(String s, Object o, Object o1) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void info(String s, Object ... objects) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)objects));
    }

    public void info(String s, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY, (Throwable)throwable));
    }

    public boolean isWarnEnabled() {
        return this.isEnalbed(Level.WARN);
    }

    public void warn(String s) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY));
    }

    public void warn(String s, Object o) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o));
    }

    public void warn(String s, Object ... objects) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)objects));
    }

    public void warn(String s, Object o, Object o1) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void warn(String s, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY, (Throwable)throwable));
    }

    public boolean isErrorEnabled() {
        return this.isEnalbed(Level.ERROR);
    }

    public void error(String s) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY));
    }

    public void error(String s, Object o) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o));
    }

    public void error(String s, Object o, Object o1) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)o, (Object)o1));
    }

    public void error(String s, Object ... objects) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.format((String)s, (Object)objects));
    }

    public void error(String s, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.append(MessageFormatter.arrayFormat((String)s, (Object[])MessageConverter.EMPTY_ARRAY, (Throwable)throwable));
    }

    private boolean isEnalbed(Level lvl) {
        return this.level.toInt() <= lvl.toInt();
    }

    private void append(FormattingTuple tuple) {
        this.logs.add(MessageConverter.convert(tuple));
    }
}

