/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.facade;

import com.jxdinfo.hussar.logic.engine.api.DebugLogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.DebugRuntimePool;
import com.jxdinfo.hussar.logic.engine.api.EngineFactory;
import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.api.SourceEventListener;
import com.jxdinfo.hussar.logic.engine.facade.RuntimeFactory;
import com.jxdinfo.hussar.logic.engine.facade.SandboxDebugRuntimeFactory;
import com.jxdinfo.hussar.logic.engine.facade.SandboxRuntime;
import com.jxdinfo.hussar.logic.engine.facade.global.cnst.Namespace;
import com.jxdinfo.hussar.logic.engine.facade.repo.SourceResourceLoader;
import com.jxdinfo.hussar.logic.engine.facade.service.DefaultSourceEventListener;
import com.jxdinfo.hussar.logic.engine.facade.service.SourceServiceImpl;
import com.jxdinfo.hussar.logic.engine.facade.simple.LogicRuntimeUtil;
import com.jxdinfo.hussar.logic.engine.facade.simple.SimpleLogicRuntime;
import com.jxdinfo.hussar.logic.engine.facade.simple.debug.DebugRuntimePoolImpl;
import com.jxdinfo.hussar.logic.engine.facade.simple.debug.DebugSimpleRuntimeFactory;
import com.jxdinfo.hussar.logic.engine.janino.CompilationCustomizer;
import com.jxdinfo.hussar.logic.engine.janino.CompilerConfig;
import com.jxdinfo.hussar.logic.engine.janino.JaninoEngineFactory;
import com.jxdinfo.hussar.logic.engine.janino.security.ClassAllowableCheckerCustomizer;
import com.jxdinfo.hussar.logic.engine.security.ClassAllowableChecker;
import com.jxdinfo.hussar.logic.engine.security.MethodAllowableChecker;
import com.jxdinfo.hussar.logic.engine.security.ObjectMethodChecker;
import com.jxdinfo.hussar.logic.engine.security.PrivilegedSandbox;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

public class LogicRuntimeConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DebugRuntimePool.class})
    public DebugRuntimePool debugRuntimePool(ObjectProvider<ClassAllowableChecker> classChecker, ObjectProvider<MethodAllowableChecker> methodChecker, ObjectProvider<PrivilegedSandbox> sandbox) {
        DebugSimpleRuntimeFactory simpleRuntimeFactory;
        JaninoEngineFactory factory = new JaninoEngineFactory();
        ClassAllowableChecker checkerIfAvailable = (ClassAllowableChecker)classChecker.getIfAvailable();
        if (checkerIfAvailable != null) {
            CompilerConfig config = new CompilerConfig();
            ClassAllowableCheckerCustomizer customizer = new ClassAllowableCheckerCustomizer();
            customizer.setClassChecker(checkerIfAvailable);
            if (methodChecker.getIfAvailable() != null) {
                customizer.setMethodChecker((MethodAllowableChecker)new ObjectMethodChecker());
            }
            config.addCompilationCustomizer((CompilationCustomizer)customizer);
            factory.setConfig(config);
        }
        RuntimeFactory<DebugLogicRuntime> runtimeFactory = simpleRuntimeFactory = new DebugSimpleRuntimeFactory((EngineFactory)factory);
        PrivilegedSandbox sandboxIfAvailable = (PrivilegedSandbox)sandbox.getIfAvailable();
        if (sandboxIfAvailable != null) {
            runtimeFactory = new SandboxDebugRuntimeFactory(runtimeFactory, sandboxIfAvailable);
        }
        return new DebugRuntimePoolImpl(runtimeFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={LogicRuntime.class})
    public LogicRuntime logicRuntime(ObjectProvider<ClassAllowableChecker> classChecker, ObjectProvider<MethodAllowableChecker> methodChecker, ObjectProvider<PrivilegedSandbox> sandbox) {
        JaninoEngineFactory factory = new JaninoEngineFactory((ResourceLoader)new SourceResourceLoader(Namespace.PROD.name()));
        CompilerConfig config = new CompilerConfig();
        config.setDebugSource(true);
        config.setDebugLines(true);
        config.setDebugVars(true);
        if (classChecker.getIfAvailable() != null) {
            ClassAllowableCheckerCustomizer customizer = new ClassAllowableCheckerCustomizer();
            customizer.setClassChecker((ClassAllowableChecker)classChecker.getObject());
            if (methodChecker.getIfAvailable() != null) {
                customizer.setMethodChecker((MethodAllowableChecker)new ObjectMethodChecker());
            }
            config.addCompilationCustomizer((CompilationCustomizer)customizer);
        }
        factory.setConfig(config);
        SimpleLogicRuntime simpleLogicRuntime = new SimpleLogicRuntime();
        simpleLogicRuntime.setEngine(factory.create());
        Object runtime = simpleLogicRuntime;
        PrivilegedSandbox sandboxIfAvailable = (PrivilegedSandbox)sandbox.getIfAvailable();
        if (sandboxIfAvailable != null) {
            runtime = new SandboxRuntime<SimpleLogicRuntime>(sandboxIfAvailable, (SimpleLogicRuntime)runtime);
        }
        LogicRuntimeUtil.setInstance(runtime);
        return runtime;
    }

    @Bean
    @ConditionalOnMissingBean(value={SourceService.class})
    public SourceService sourceService() {
        return new SourceServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={SourceEventListener.class})
    public DefaultSourceEventListener defaultSourceEventListener() {
        return new DefaultSourceEventListener();
    }
}

