/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.engine.bean;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DebugPosition {
    private final String clazz;
    private final int line;
    private final int column;
    private final List<String> components;

    private DebugPosition(String clazz, int line, int column, List<String> components) {
        this.clazz = clazz;
        this.line = line;
        this.column = column;
        this.components = components;
    }

    public static DebugPosition of(String clazz, String ... components) {
        return DebugPosition.of(clazz, -1, -1, Arrays.asList(components));
    }

    public static DebugPosition of(String clazz, List<String> components) {
        return DebugPosition.of(clazz, -1, -1, components);
    }

    public static DebugPosition of(String clazz, int line, String ... components) {
        return DebugPosition.of(clazz, line, -1, Arrays.asList(components));
    }

    public static DebugPosition of(String clazz, int line, List<String> components) {
        return DebugPosition.of(clazz, line, -1, components);
    }

    public static DebugPosition of(String clazz, int line, int column, String ... components) {
        return new DebugPosition(clazz, line, column, Arrays.asList(components));
    }

    public static DebugPosition of(String clazz, int line, int column, List<String> components) {
        components = components != null ? Collections.unmodifiableList(components) : Collections.emptyList();
        return new DebugPosition(clazz, line, column, components);
    }

    public String getClazz() {
        return this.clazz;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public String toString() {
        return "DebugPosition{clazz='" + this.clazz + '\'' + ", line=" + this.line + ", column=" + this.column + ", components=" + this.components + '}';
    }
}

