package ${packageName};

<#list imports as import>
import ${import.canonicalClassName};
</#list>

@Service("${beanName?j_string}")
public class ${className} implements ${interfaceName} {
    private static final Logger logger = LoggerFactory.getLogger(${className}.class);

    <#-- service 定义 -->
    <#list services as service>
    <#if service.required>
    @${autowiredClassName}
    <#else>
    @${autowiredClassName}(required = false)
    </#if>
    <#if service.userland>@${lazyClassName}</#if>
    private ${service.className} ${service.serviceName};
    </#list>

    <#-- invoke 方法定义 -->

    @Override
    public <#if result??>${result.type.code}<#else>void</#if> invoke(
        <#list parameters as parameter>
        ${parameter.type.code} ${parameter.name}<#sep>, </#sep>
        </#list>
    ) {
        <#-- 入参变量默认值初始化 -->
        <#list parameters as parameter>
        <#if parameter.hasDefault>
        ${parameter.name} = ${parameter.name} != null ? ${parameter.name} : ${parameter.defaultLiteral};
        </#if>
        </#list>

        <#-- 出参变量初始化 -->
        <#if result?? && result.name?has_content>
        <#if result.hasDefault>
        ${result.type.code} ${result.name} = ${result.defaultLiteral};
        <#else>
        ${result.type.code} ${result.name} = null;
        </#if>
        </#if>

        <#-- 根组件代码 -->
        <@slot name="body"/>
    }

    <#if dtoName??>
    @Override
    public <#if result??>${result.type.code}<#else>void</#if> invokeByDto(${dtoName} ${dtoName?uncap_first}) {
        <#list parameters as parameter>
        ${parameter.type.code} ${parameter.name} = ${dtoName?uncap_first}.get${parameter.name?cap_first}();
        </#list>

        <#if result??>
        return invoke(<#list parameters as parameter>${parameter.name}<#sep>, </#sep></#list>);
        <#else>
        invoke(<#list parameters as parameter>${parameter.name}<#sep>, </#sep></#list>);
        </#if>
    }
    </#if>

    <#-- 私有方法定义 -->
    <#list methods as method>
    <#if method.title?has_content && method.description?has_content>
    /**
     * ${method.title}
     *
     * ${method.description}
     */
    <#elseif method.title?has_content>
    /**
     * ${method.title}
     */
    <#elseif method.description?has_content>
    /**
     * ${method.description}
     */
    </#if>
    private <#if method.result??>${method.result.type.code}<#else>void</#if> ${method.name}(
        <#if method.parameters??>
        <#list method.parameters as parameter>
        ${parameter.type.code} ${parameter.name}<#sep>, </#sep>
        </#list>
        </#if>
    ) {
        <@slot name="method_${method.name}"/>
    }
    </#list>
}
