/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.utils;

import com.jxdinfo.hussar.logic.generator.utils.BackendClassNameUtils;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.metadata.LogicMetadata;
import com.jxdinfo.hussar.logic.utils.LogicPathUtils;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class BackendMvcClassNameUtils {
    private BackendMvcClassNameUtils() {
    }

    public static String apiHttpPathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.posixPath((String[])new String[]{"/", configure.getBackendApiPrefix(), String.join((CharSequence)"/", metadata.getModules()), metadata.getName(), "invoke"});
    }

    public static String checkPermissionCodeOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        String api = BackendMvcClassNameUtils.apiHttpPathOf(metadata, configure);
        return Arrays.stream(api.split("/")).filter(StringUtils::isNotEmpty).collect(Collectors.joining(":"));
    }

    public static String apiJsFilePathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.systemPath((String[])new String[]{configure.getFrontendProjectSourceRoot(), configure.getFrontendApiModule(), BackendMvcClassNameUtils.apiJsPathSegmentOf(metadata, configure)});
    }

    public static String apiJsImportPathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.posixPath((String[])new String[]{"#/api", BackendMvcClassNameUtils.apiJsPathSegmentOf(metadata, configure)});
    }

    public static String apiJsPathSegmentOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.posixPath((String[])new String[]{String.join((CharSequence)"/", metadata.getModules()), metadata.getName() + ".js"});
    }

    public static String controllerClassNameOf(LogicMetadata metadata) {
        return BackendClassNameUtils.identifierToClassName((String)metadata.getName()) + "Controller";
    }

    public static String controllerQualifiedClassOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.packagePath((String[])new String[]{configure.getBackendPrefixPackage(), String.join((CharSequence)".", metadata.getModules()), StringUtils.lowerCase((String)metadata.getName()), configure.getBackendControllerPackage()}) + "." + BackendMvcClassNameUtils.controllerClassNameOf(metadata);
    }

    public static String controllerFilePathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.systemPath((String[])new String[]{configure.getBackendProjectSourceRoot(), LogicPathUtils.packageToPosixPath((String)BackendMvcClassNameUtils.controllerQualifiedClassOf(metadata, configure)) + ".java"});
    }

    public static String controllerBeanNameOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.packagePath((String[])new String[]{String.join((CharSequence)".", metadata.getModules()), StringUtils.lowerCase((String)metadata.getName())}) + "." + BackendMvcClassNameUtils.controllerClassNameOf(metadata);
    }

    public static String invokeDtoClassNameOf(LogicMetadata metadata) {
        return BackendClassNameUtils.identifierToClassName((String)metadata.getName()) + "InvokeDto";
    }

    public static String invokeDtoQualifiedClassOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.packagePath((String[])new String[]{configure.getBackendPrefixPackage(), String.join((CharSequence)".", metadata.getModules()), StringUtils.lowerCase((String)metadata.getName()), configure.getBackendDtoPackage()}) + "." + BackendMvcClassNameUtils.invokeDtoClassNameOf(metadata);
    }

    public static String invokeDtoFilePathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.systemPath((String[])new String[]{configure.getBackendProjectSourceRoot(), LogicPathUtils.packageToPosixPath((String)BackendMvcClassNameUtils.invokeDtoQualifiedClassOf(metadata, configure)) + ".java"});
    }

    public static String serviceInterfaceClassNameOf(LogicMetadata metadata) {
        return BackendClassNameUtils.identifierToClassName((String)metadata.getName()) + "Service";
    }

    public static String serviceInterfaceQualifiedClassOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.packagePath((String[])new String[]{configure.getBackendPrefixPackage(), String.join((CharSequence)".", metadata.getModules()), StringUtils.lowerCase((String)metadata.getName()), configure.getBackendServiceInterfacePackage()}) + "." + BackendMvcClassNameUtils.serviceInterfaceClassNameOf(metadata);
    }

    public static String serviceInterfaceFilePathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.systemPath((String[])new String[]{configure.getBackendProjectSourceRoot(), LogicPathUtils.packageToPosixPath((String)BackendMvcClassNameUtils.serviceInterfaceQualifiedClassOf(metadata, configure)) + ".java"});
    }

    public static String serviceImplClassNameOf(LogicMetadata metadata) {
        return BackendClassNameUtils.identifierToClassName((String)metadata.getName()) + "ServiceImpl";
    }

    public static String serviceImplQualifiedClassOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.packagePath((String[])new String[]{configure.getBackendPrefixPackage(), String.join((CharSequence)".", metadata.getModules()), StringUtils.lowerCase((String)metadata.getName()), configure.getBackendServiceImplPackage()}) + "." + BackendMvcClassNameUtils.serviceImplClassNameOf(metadata);
    }

    public static String serviceImplFilePathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.systemPath((String[])new String[]{configure.getBackendProjectSourceRoot(), LogicPathUtils.packageToPosixPath((String)BackendMvcClassNameUtils.serviceImplQualifiedClassOf(metadata, configure)) + ".java"});
    }

    public static String serviceImplBeanNameOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.packagePath((String[])new String[]{String.join((CharSequence)".", metadata.getModules()), StringUtils.lowerCase((String)metadata.getName())}) + "." + BackendMvcClassNameUtils.serviceImplClassNameOf(metadata);
    }
}

