/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.provider;

import com.jxdinfo.hussar.logic.exception.HussarLogicSourceMapException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateProviderService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicMvcGenerateContext;
import com.jxdinfo.hussar.logic.generator.context.LogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.context.LogicSimpleGenerateContext;
import com.jxdinfo.hussar.logic.generator.provider.LogicGenerateProvider;
import com.jxdinfo.hussar.logic.generator.render.LogicRenderTemplate;
import com.jxdinfo.hussar.logic.generator.resolver.DefaultLogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.generator.resolver.LogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.generator.utils.BackendClassNameUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendCodeFormatUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendMvcClassNameUtils;
import com.jxdinfo.hussar.logic.generator.utils.LogicCanvasConvertUtils;
import com.jxdinfo.hussar.logic.properties.HussarLogicProperties;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendImportDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendMethodDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendServiceDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateSource;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationFrontend;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationPlatform;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFileType;
import com.jxdinfo.hussar.logic.structure.metadata.LogicMetadata;
import com.jxdinfo.hussar.logic.structure.type.LogicBackendType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;

@LogicGenerateProviderService(name="backend-mvc", taints={"language:java", "runtime:mvc"})
public class BackendLogicMvcGenerateProvider
implements LogicGenerateProvider {
    public static final String PROVIDER_NAME = "backend-mvc";
    private final HussarLogicProperties properties;
    private static final String SERVICE_IMPL_TEMPLATE_PATH = "/template/logic/mvc/service_impl.ftl";
    private static final List<String> SERVICE_IMPL_INITIAL_IMPORTS = Arrays.asList("org.slf4j.Logger", "org.slf4j.LoggerFactory", "org.springframework.stereotype.Service");
    private static final String SERVICE_IMPL_AUTOWIRED_IMPORT = "org.springframework.beans.factory.annotation.Autowired";
    private static final String SERVICE_IMPL_LAZY_IMPORT = "org.springframework.context.annotation.Lazy";
    private static final Map<String, String> SERVICE_IMPL_INITIAL_FIELDS = new LinkedHashMap<String, String>();
    private static final List<String> SERVICE_IMPL_INITIAL_METHODS;
    private static final String SERVICE_INTERFACE_TEMPLATE_PATH = "/template/logic/mvc/service_interface.ftl";
    private static final List<String> SERVICE_INTERFACE_INITIAL_IMPORTS;
    private static final String INVOKE_DTO_TEMPLATE_PATH = "/template/logic/mvc/invoke_dto.ftl";
    private static final List<String> INVOKE_DTO_INITIAL_IMPORTS;
    private static final String CONTROLLER_TEMPLATE_PATH = "/template/logic/mvc/controller.ftl";
    private static final List<String> CONTROLLER_INITIAL_IMPORTS;
    private static final String CONTROLLER_CHECK_PERMISSION_IMPORT = "com.jxdinfo.hussar.support.security.core.annotation.CheckPermission";
    private static final String API_WEB_TEMPLATE_PATH = "/template/logic/mvc/api_web.ftl";
    private static final String API_MOBILE_TEMPLATE_PATH = "/template/logic/mvc/api_mobile.ftl";

    @Autowired
    public BackendLogicMvcGenerateProvider(HussarLogicProperties properties) {
        this.properties = properties;
    }

    public LogicGenerateResult generate(LogicGenerateSource source, LogicGenerateConfigure configure) {
        this.normalizeConfigure(configure);
        LogicMetadata metadata = LogicCanvasConvertUtils.convertMetadata((LogicGenerateSource)source);
        ArrayList<LogicGenerateFile> files = new ArrayList<LogicGenerateFile>();
        files.add(this.generateServiceImpl(metadata, source, configure));
        files.add(this.generateServiceInterface(metadata, source, configure));
        if (!MapUtils.isEmpty((Map)metadata.getParameters())) {
            files.add(this.generateInvokeDto(metadata, source, configure));
        }
        files.add(this.generateController(metadata, source, configure));
        if (this.shouldGenerateApiJs(configure)) {
            files.add(this.generateApiJs(metadata, source, configure));
        }
        LogicGenerateResult result = new LogicGenerateResult();
        result.setApi(BackendMvcClassNameUtils.apiHttpPathOf(metadata, configure));
        result.setParameterNames(new ArrayList(metadata.getParameters().keySet()));
        result.setReturnsVoid(metadata.getResult() == null);
        result.setFiles(files);
        return result;
    }

    private void normalizeConfigure(LogicGenerateConfigure configure) {
        if (configure.getBackendExternalResolver() == null) {
            configure.setBackendExternalResolver((LogicBackendExternalResolver)new DefaultLogicBackendExternalResolver());
        }
        if (configure.getAllowCodeFormat() == null) {
            configure.setAllowCodeFormat(this.properties.getAllowCodeFormat());
        }
        configure.setAllowSourceMap(Boolean.valueOf(false));
        if (configure.getBackendAllowFieldShadowing() == null) {
            configure.setBackendAllowFieldShadowing(this.properties.getBackendAllowFieldShadowing());
        }
        if (configure.getAllowCheckPermission() == null) {
            configure.setAllowCheckPermission(Boolean.valueOf(false));
        }
    }

    private boolean shouldGenerateApiJs(LogicGenerateConfigure configure) {
        return configure.getPlatform() == LogicGenerationPlatform.LOW_CODE_PLATFORM && Optional.ofNullable(this.properties.getBackendGenerateApiJs()).orElse(true) != false;
    }

    private LogicGenerateFile generateServiceImpl(LogicMetadata metadata, LogicGenerateSource source, LogicGenerateConfigure configure) {
        LogicBackendImportDefinition serviceImplClass = BackendClassNameUtils.parseQualifiedClass((String)BackendMvcClassNameUtils.serviceImplQualifiedClassOf(metadata, configure));
        BackendLogicMvcGenerateContext context = this.createBackendGenerateContext(metadata, source, configure, serviceImplClass.getQualifiedClassName(), SERVICE_IMPL_INITIAL_IMPORTS, SERVICE_IMPL_INITIAL_FIELDS, SERVICE_IMPL_INITIAL_METHODS);
        String beanName = BackendMvcClassNameUtils.serviceImplBeanNameOf(metadata, configure);
        String serviceInterfaceClassName = context.addImport(BackendMvcClassNameUtils.serviceInterfaceQualifiedClassOf(metadata, configure));
        String invokeDtoClassName = null;
        if (!MapUtils.isEmpty((Map)metadata.getParameters())) {
            invokeDtoClassName = context.addImport(BackendMvcClassNameUtils.invokeDtoQualifiedClassOf(metadata, configure));
        }
        List parameters = metadata.getParameters().values().stream().map(arg_0 -> ((BackendLogicMvcGenerateContext)context).addVariable(arg_0)).collect(Collectors.toList());
        LogicBackendVariableDefinition result = metadata.getResult() != null ? context.addVariable(metadata.getResult()) : null;
        LogicGeneratedCode body = context.generate(source.getRoot(), new Object[0]);
        String autowiredClassName = null;
        String lazyClassName = null;
        List services = context.getServices();
        if (services != null && services.size() > 0) {
            autowiredClassName = context.addImport(SERVICE_IMPL_AUTOWIRED_IMPORT);
            if (services.stream().anyMatch(LogicBackendServiceDefinition::isUserland)) {
                lazyClassName = context.addImport(SERVICE_IMPL_LAZY_IMPORT);
            }
        }
        List methods = context.getMethods();
        LinkedHashMap<String, LogicGeneratedCode> slots = new LinkedHashMap<String, LogicGeneratedCode>();
        slots.put("body", body);
        for (LogicBackendMethodDefinition method : methods) {
            slots.put("method_" + method.getName(), method.getBody());
        }
        LogicGeneratedCode raw = LogicRenderTemplate.begin((LogicGenerateContext)context, (LogicCanvasComponent)source.getRoot(), (String)SERVICE_IMPL_TEMPLATE_PATH).parameter("className", (Object)serviceImplClass.getSimpleName()).parameter("packageName", (Object)serviceImplClass.getPackageName()).parameter("beanName", (Object)beanName).parameter("interfaceName", (Object)serviceInterfaceClassName).parameter("dtoName", (Object)invokeDtoClassName).parameter("autowiredClassName", (Object)autowiredClassName).parameter("lazyClassName", (Object)lazyClassName).parameter("imports", (Object)context.getImports()).parameter("services", (Object)services).parameter("parameters", parameters).parameter("result", (Object)result).parameter("methods", (Object)methods).slots(slots).render();
        LogicGeneratedCode code = this.formatBackendCode(raw, configure);
        LogicGenerateFile file = new LogicGenerateFile();
        file.setId(BackendMvcClassNameUtils.serviceImplQualifiedClassOf(context.getMetadata(), configure));
        file.setType(LogicGenerateFileType.SERVICE_IMPL);
        file.setPath(BackendMvcClassNameUtils.serviceImplFilePathOf(context.getMetadata(), configure));
        file.setContent(code.getCode());
        file.setSourceMap(null);
        return file;
    }

    private LogicGenerateFile generateServiceInterface(LogicMetadata metadata, LogicGenerateSource source, LogicGenerateConfigure configure) {
        LogicBackendImportDefinition serviceInterfaceClass = BackendClassNameUtils.parseQualifiedClass((String)BackendMvcClassNameUtils.serviceInterfaceQualifiedClassOf(metadata, configure));
        BackendLogicMvcGenerateContext context = this.createBackendGenerateContext(metadata, source, configure, serviceInterfaceClass.getQualifiedClassName(), SERVICE_INTERFACE_INITIAL_IMPORTS, null, null);
        String invokeDtoClassName = MapUtils.isEmpty((Map)metadata.getParameters()) ? null : context.addImport(BackendMvcClassNameUtils.invokeDtoQualifiedClassOf(metadata, configure));
        List parameters = metadata.getParameters().values().stream().map(arg_0 -> ((BackendLogicMvcGenerateContext)context).addVariable(arg_0)).collect(Collectors.toList());
        LogicBackendVariableDefinition result = metadata.getResult() != null ? context.addVariable(metadata.getResult()) : null;
        LogicGeneratedCode raw = LogicRenderTemplate.begin((LogicGenerateContext)context, (LogicCanvasComponent)source.getRoot(), (String)SERVICE_INTERFACE_TEMPLATE_PATH).parameter("className", (Object)serviceInterfaceClass.getSimpleName()).parameter("packageName", (Object)serviceInterfaceClass.getPackageName()).parameter("dtoName", (Object)invokeDtoClassName).parameter("imports", (Object)context.getImports()).parameter("parameters", parameters).parameter("result", (Object)result).render();
        LogicGeneratedCode code = this.formatBackendCode(raw, configure);
        LogicGenerateFile file = new LogicGenerateFile();
        file.setId(BackendMvcClassNameUtils.serviceInterfaceQualifiedClassOf(context.getMetadata(), configure));
        file.setType(LogicGenerateFileType.SERVICE_INTERFACE);
        file.setPath(BackendMvcClassNameUtils.serviceInterfaceFilePathOf(context.getMetadata(), configure));
        file.setContent(code.getCode());
        file.setSourceMap(null);
        return file;
    }

    private LogicGenerateFile generateInvokeDto(LogicMetadata metadata, LogicGenerateSource source, LogicGenerateConfigure configure) {
        LogicBackendImportDefinition invokeDtoClass = BackendClassNameUtils.parseQualifiedClass((String)BackendMvcClassNameUtils.invokeDtoQualifiedClassOf(metadata, configure));
        BackendLogicMvcGenerateContext context = this.createBackendGenerateContext(metadata, source, configure, invokeDtoClass.getQualifiedClassName(), INVOKE_DTO_INITIAL_IMPORTS, null, null);
        List parameters = metadata.getParameters().values().stream().map(arg_0 -> ((BackendLogicMvcGenerateContext)context).addVariable(arg_0)).collect(Collectors.toList());
        LogicGeneratedCode raw = LogicRenderTemplate.begin((LogicGenerateContext)context, (LogicCanvasComponent)source.getRoot(), (String)INVOKE_DTO_TEMPLATE_PATH).parameter("className", (Object)invokeDtoClass.getSimpleName()).parameter("packageName", (Object)invokeDtoClass.getPackageName()).parameter("imports", (Object)context.getImports()).parameter("parameters", parameters).render();
        LogicGeneratedCode code = this.formatBackendCode(raw, configure);
        LogicGenerateFile file = new LogicGenerateFile();
        file.setId(BackendMvcClassNameUtils.invokeDtoQualifiedClassOf(context.getMetadata(), configure));
        file.setType(LogicGenerateFileType.DTO_POJO);
        file.setPath(BackendMvcClassNameUtils.invokeDtoFilePathOf(context.getMetadata(), configure));
        file.setContent(code.getCode());
        file.setSourceMap(null);
        return file;
    }

    private LogicGenerateFile generateController(LogicMetadata metadata, LogicGenerateSource source, LogicGenerateConfigure configure) {
        LogicBackendImportDefinition controllerClass = BackendClassNameUtils.parseQualifiedClass((String)BackendMvcClassNameUtils.controllerQualifiedClassOf(metadata, configure));
        BackendLogicMvcGenerateContext context = this.createBackendGenerateContext(metadata, source, configure, controllerClass.getQualifiedClassName(), CONTROLLER_INITIAL_IMPORTS, null, null);
        String beanName = BackendMvcClassNameUtils.controllerBeanNameOf(metadata, configure);
        String serviceInterfaceClassName = context.addImport(BackendMvcClassNameUtils.serviceInterfaceQualifiedClassOf(metadata, configure));
        String invokeDtoClassName = null;
        String requestBodyClassName = null;
        if (!MapUtils.isEmpty((Map)metadata.getParameters())) {
            invokeDtoClassName = context.addImport(BackendMvcClassNameUtils.invokeDtoQualifiedClassOf(metadata, configure));
            requestBodyClassName = context.addImport("org.springframework.web.bind.annotation.RequestBody");
        }
        String apiPath = BackendMvcClassNameUtils.apiHttpPathOf(metadata, configure);
        LogicBackendVariableDefinition result = metadata.getResult() != null ? context.addVariable(metadata.getResult()) : null;
        String checkPermissionClassName = null;
        String checkPermissionCode = null;
        if (Optional.ofNullable(configure.getAllowCheckPermission()).orElse(false).booleanValue()) {
            checkPermissionClassName = context.addImport(CONTROLLER_CHECK_PERMISSION_IMPORT);
            checkPermissionCode = BackendMvcClassNameUtils.checkPermissionCodeOf(metadata, configure);
        }
        LogicGeneratedCode raw = LogicRenderTemplate.begin((LogicGenerateContext)context, (LogicCanvasComponent)source.getRoot(), (String)CONTROLLER_TEMPLATE_PATH).parameter("className", (Object)controllerClass.getSimpleName()).parameter("packageName", (Object)controllerClass.getPackageName()).parameter("beanName", (Object)beanName).parameter("interfaceName", (Object)serviceInterfaceClassName).parameter("dtoName", (Object)invokeDtoClassName).parameter("requestBodyName", (Object)requestBodyClassName).parameter("checkPermissionName", (Object)checkPermissionClassName).parameter("checkPermissionCode", (Object)checkPermissionCode).parameter("imports", (Object)context.getImports()).parameter("apiPath", (Object)apiPath).parameter("result", (Object)result).render();
        LogicGeneratedCode code = this.formatBackendCode(raw, configure);
        LogicGenerateFile file = new LogicGenerateFile();
        file.setId(BackendMvcClassNameUtils.controllerQualifiedClassOf(context.getMetadata(), configure));
        file.setType(LogicGenerateFileType.CONTROLLER);
        file.setPath(BackendMvcClassNameUtils.controllerFilePathOf(context.getMetadata(), configure));
        file.setContent(code.getCode());
        file.setSourceMap(null);
        return file;
    }

    private LogicGenerateFile generateApiJs(LogicMetadata metadata, LogicGenerateSource source, LogicGenerateConfigure configure) {
        String template;
        LogicSimpleGenerateContext context = new LogicSimpleGenerateContext(metadata, configure, source.getRoot());
        String logicName = BackendClassNameUtils.identifierToClassName((String)metadata.getName());
        String apiPath = BackendMvcClassNameUtils.apiHttpPathOf(metadata, configure);
        LogicGenerationFrontend frontend = Optional.ofNullable(configure.getFrontend()).orElse(LogicGenerationFrontend.WEB_FRONTEND);
        switch (frontend) {
            case WEB_FRONTEND: {
                template = API_WEB_TEMPLATE_PATH;
                break;
            }
            case MOBILE_FRONTEND: {
                template = API_MOBILE_TEMPLATE_PATH;
                break;
            }
            default: {
                throw new IllegalStateException("api frontend type not supported");
            }
        }
        LogicGeneratedCode code = LogicRenderTemplate.begin((LogicGenerateContext)context, (LogicCanvasComponent)source.getRoot(), (String)template).parameter("logicName", (Object)logicName).parameter("apiPath", (Object)apiPath).render();
        LogicGenerateFile file = new LogicGenerateFile();
        file.setId(BackendMvcClassNameUtils.apiJsImportPathOf(context.getMetadata(), configure));
        file.setType(LogicGenerateFileType.JS_API);
        file.setPath(BackendMvcClassNameUtils.apiJsFilePathOf(context.getMetadata(), configure));
        file.setContent(code.getCode());
        file.setSourceMap(null);
        return file;
    }

    private BackendLogicMvcGenerateContext createBackendGenerateContext(LogicMetadata metadata, LogicGenerateSource source, LogicGenerateConfigure configure, String selfClass, List<String> initialImports, Map<String, String> initialFields, List<String> initialMethods) {
        BackendLogicMvcGenerateContext context = new BackendLogicMvcGenerateContext(metadata, configure, source.getRoot(), selfClass);
        if (initialImports != null) {
            for (String string : initialImports) {
                context.addImport(string);
            }
        }
        if (initialFields != null) {
            for (Map.Entry entry : initialFields.entrySet()) {
                LogicBackendVariableDefinition definition = new LogicBackendVariableDefinition();
                definition.setName((String)entry.getKey());
                definition.setType(LogicBackendType.of((String)((String)entry.getValue())));
                context.addGlobalVariable(definition);
            }
        }
        if (initialMethods != null) {
            for (String string : initialMethods) {
                context.addPredefinedMethod(string);
            }
        }
        return context;
    }

    private LogicGeneratedCode formatBackendCode(LogicGeneratedCode raw, LogicGenerateConfigure configure) {
        LogicGeneratedCode code;
        boolean allowCodeFormat = Optional.ofNullable(configure.getAllowCodeFormat()).orElse(true);
        boolean allowSourceMap = Optional.ofNullable(configure.getAllowSourceMap()).orElse(true);
        if (allowCodeFormat) {
            code = BackendCodeFormatUtils.format((LogicGeneratedCode)raw, (boolean)allowSourceMap);
        } else {
            code = new LogicGeneratedCode();
            code.setCode(raw.getCode());
            if (allowSourceMap) {
                if (code.getSourceMap() == null) {
                    throw new HussarLogicSourceMapException("missing source map");
                }
                code.setSourceMap(code.getSourceMap().optimize());
            }
        }
        return code;
    }

    static {
        SERVICE_IMPL_INITIAL_FIELDS.put("logger", "org.slf4j.Logger");
        SERVICE_IMPL_INITIAL_METHODS = Arrays.asList("invoke", "invokeByDto", "invokeByMap");
        SERVICE_INTERFACE_INITIAL_IMPORTS = Collections.emptyList();
        INVOKE_DTO_INITIAL_IMPORTS = Collections.emptyList();
        CONTROLLER_INITIAL_IMPORTS = Arrays.asList("org.springframework.web.bind.annotation.RestController", "org.springframework.web.bind.annotation.PostMapping", SERVICE_IMPL_AUTOWIRED_IMPORT, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }
}

