package ${packageName};

<#list imports as import>
import ${import.canonicalClassName};
</#list>

<#if _metadata.title?has_content && _metadata.description?has_content>
/**
 * ${_metadata.title}
 *
 * ${_metadata.description}
 */
<#elseif _metadata.title?has_content>
/**
 * ${_metadata.title}
 */
<#elseif _metadata.description?has_content>
/**
 * ${_metadata.description}
 */
</#if>
<@slot name="meta"/>
@SuppressWarnings("unused")
public class ${className} implements LogicRuntimeAware, LogicExecutionContextAware, LogicMetadataSupplier {
    public static Logger logger = LoggerFactory.getLogger(${className}.class);
    private static volatile LogicRuntimeMetadata metadata;

    private LogicRuntime runtime;
    private LogicExecutionContext execution;

    <#-- service 字段 -->
    private volatile boolean initialized = false;
    <#list services as service>
    private ${service.className} ${service.serviceName};
    </#list>

    <#-- invoke 方法定义 -->

    /**
     * <#if _metadata.title?has_content>${_metadata.title}<#else>逻辑调用</#if>
     <#if parameters?has_content || !result??>
     *
     <#list parameters as parameter>
     * @param ${parameter.name}<#if parameter.title?has_content> ${parameter.title}</#if>
     </#list>
     <#if result??>
     * @return<#if result.title?has_content> ${result.title}</#if>
     </#if>
     </#if>
     */
    public <#if result??>${result.type.code}<#else>void</#if> invoke(
        <#list parameters as parameter>
        ${parameter.type.code} ${parameter.name}<#sep>, </#sep>
        </#list>
    ) {
        <#-- 线程中断检查点 -->
        LogicSupportUtils.checkpoint();

        <#-- 触发 service 初始化 -->
        initialize();

        <#-- 入参变量默认值初始化 -->
        <#list parameters as parameter>
        <#if parameter.hasDefault>
        ${parameter.name} = ${parameter.name} != null ? ${parameter.name} : ${parameter.defaultLiteral};
        </#if>
        </#list>

        <#-- 出参变量初始化 -->
        <#if result?? && result.name?has_content>
        <#if result.hasDefault>
        ${result.type.code} ${result.name} = ${result.defaultLiteral};
        <#else>
        ${result.type.code} ${result.name} = null;
        </#if>
        </#if>

        <#-- 根组件代码 -->
        <@slot name="body"/>
    }

    <#-- service 初始化 -->
    private void initialize() {
        if (!initialized) {
            synchronized (this) {
                if (!initialized) {
                    <#-- required=true 初始化 -->
                    <#list services as service>
                    <#if service.required>
                    this.${service.serviceName} = ${springContextHolderName}.getBean(${service.className}.class);
                    </#if>
                    </#list>
                    <#-- required=false 初始化 -->
                    <#list services as service>
                    <#if !service.required>
                    try {
                        this.${service.serviceName} = ${springContextHolderName}.getBean(${service.className}.class);
                    } catch (Exception ignore) {
                    }
                    </#if>
                    </#list>

                    initialized = true;
                }
            }
        }
    }

    <#-- 实现 LogicRuntimeAware -->
    @Override
    public LogicRuntime getLogicRuntime() {
        return this.runtime;
    }
    @Override
    public void setLogicRuntime(LogicRuntime runtime) {
        this.runtime = runtime;
    }

    <#-- 实现 LogicExecutionContextAware -->
    @Override
    public LogicExecutionContext getExecutionContext() {
        return this.execution;
    }
    @Override
    public void setExecutionContext(LogicExecutionContext execution) {
        this.execution = execution;
    }

    <#-- 实现 LogicMetadataSupplier -->
    @Override
    public LogicRuntimeMetadata getLogicMetadata() {
        if (metadata == null) {
            synchronized (${className}.class) {
                if (metadata == null) {
                    ${className}.metadata = LogicManifestUtils.reflectMetadata(${className}.class);
                }
            }
        }
        return metadata;
    }

    <#-- 私有方法定义 -->
    <#list methods as method>
    <#if method.title?has_content && method.description?has_content>
    /**
     * ${method.title}
     *
     * ${method.description}
     */
    <#elseif method.title?has_content>
    /**
     * ${method.title}
     */
    <#elseif method.description?has_content>
    /**
     * ${method.description}
     */
    </#if>
    private <#if method.result??>${method.result.type.code}<#else>void</#if> ${method.name}(
        <#if method.parameters??>
        <#list method.parameters as parameter>
        ${parameter.type.code} ${parameter.name}<#sep>, </#sep>
        </#list>
        </#if>
    ) {
        <#-- 线程中断检查点 -->
        LogicSupportUtils.checkpoint();

        <#-- 方法体代码 -->
        <@slot name="method_${method.name}"/>
    }
    </#list>
}
