/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.utils;

import com.jxdinfo.hussar.logic.generator.utils.BackendClassNameUtils;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.metadata.LogicMetadata;
import com.jxdinfo.hussar.logic.utils.LogicPathUtils;
import org.apache.commons.lang3.StringUtils;

public final class BackendEngineClassNameUtils {
    private BackendEngineClassNameUtils() {
    }

    public static String apiHttpPathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.posixPath((String[])new String[]{"/", configure.getBackendApiPrefix(), String.join((CharSequence)"/", metadata.getModules()), metadata.getName(), "invoke"});
    }

    public static String apiJsFilePathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.systemPath((String[])new String[]{configure.getFrontendProjectSourceRoot(), BackendEngineClassNameUtils.apiJsPathSegmentOf(metadata, configure)});
    }

    public static String apiJsImportPathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.posixPath((String[])new String[]{"@", BackendEngineClassNameUtils.apiJsPathSegmentOf(metadata, configure)});
    }

    public static String apiJsPathSegmentOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.posixPath((String[])new String[]{configure.getFrontendApiModule(), String.join((CharSequence)"/", metadata.getModules()), metadata.getName() + ".js"});
    }

    public static String serviceClassNameOf(LogicMetadata metadata) {
        return BackendClassNameUtils.identifierToClassName((String)metadata.getName()) + "Service";
    }

    public static String serviceQualifiedClassOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.packagePath((String[])new String[]{configure.getBackendPrefixPackage(), String.join((CharSequence)".", metadata.getModules()), StringUtils.lowerCase((String)metadata.getName()), configure.getBackendServiceInterfacePackage()}) + "." + BackendEngineClassNameUtils.serviceClassNameOf(metadata);
    }

    public static String serviceFilePathOf(LogicMetadata metadata, LogicGenerateConfigure configure) {
        return LogicPathUtils.systemPath((String[])new String[]{configure.getBackendProjectSourceRoot(), LogicPathUtils.packageToPosixPath((String)BackendEngineClassNameUtils.serviceQualifiedClassOf(metadata, configure)) + ".java"});
    }
}

