/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.generator.provider;

import com.jxdinfo.hussar.logic.exception.HussarLogicSourceMapException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateProviderService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicEngineGenerateContext;
import com.jxdinfo.hussar.logic.generator.context.LogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.context.LogicSimpleGenerateContext;
import com.jxdinfo.hussar.logic.generator.provider.LogicGenerateProvider;
import com.jxdinfo.hussar.logic.generator.render.LogicRenderTemplate;
import com.jxdinfo.hussar.logic.generator.resolver.DefaultLogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.generator.resolver.LogicBackendExternalResolver;
import com.jxdinfo.hussar.logic.generator.utils.BackendClassNameUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendCodeFormatUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendEngineClassNameUtils;
import com.jxdinfo.hussar.logic.generator.utils.LogicCanvasConvertUtils;
import com.jxdinfo.hussar.logic.properties.HussarLogicProperties;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendImportDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendMethodDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateSource;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationFrontend;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationPlatform;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFileType;
import com.jxdinfo.hussar.logic.structure.metadata.LogicMetadata;
import com.jxdinfo.hussar.logic.structure.sourcemap.LogicSourceMap;
import com.jxdinfo.hussar.logic.structure.type.LogicBackendType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@LogicGenerateProviderService(name="backend-engine", taints={"language:java", "runtime:engine"})
public class BackendLogicEngineGenerateProvider
implements LogicGenerateProvider {
    public static final String PROVIDER_NAME = "backend-engine";
    private final HussarLogicProperties properties;
    private static final String SERVICE_TEMPLATE_PATH = "/template/logic/engine/service.ftl";
    private static final List<String> SERVICE_INITIAL_IMPORTS = Arrays.asList("org.slf4j.Logger", "org.slf4j.LoggerFactory", "com.jxdinfo.hussar.logic.engine.api.LogicRuntime", "com.jxdinfo.hussar.logic.utils.LogicSupportUtils");
    private static final String SERVICE_SPRING_CONTEXT_HOLDER_IMPORT = "com.jxdinfo.hussar.core.util.SpringContextHolder";
    private static final Map<String, String> SERVICE_INITIAL_FIELDS = new LinkedHashMap<String, String>();
    private static final List<String> SERVICE_INITIAL_METHODS;
    private static final String API_WEB_TEMPLATE_PATH = "/template/logic/engine/api_web.ftl";
    private static final String API_MOBILE_TEMPLATE_PATH = "/template/logic/engine/api_mobile.ftl";

    @Autowired
    public BackendLogicEngineGenerateProvider(HussarLogicProperties properties) {
        this.properties = properties;
    }

    public LogicGenerateResult generate(LogicGenerateSource source, LogicGenerateConfigure configure) {
        this.normalizeConfigure(configure);
        LogicMetadata metadata = LogicCanvasConvertUtils.convertMetadata((LogicGenerateSource)source);
        ArrayList<LogicGenerateFile> files = new ArrayList<LogicGenerateFile>();
        files.add(this.generateService(metadata, source, configure));
        if (this.shouldGenerateApiJs(configure)) {
            files.add(this.generateApiJs(metadata, source, configure));
        }
        LogicGenerateResult result = new LogicGenerateResult();
        result.setApi(BackendEngineClassNameUtils.apiHttpPathOf(metadata, configure));
        result.setParameterNames(new ArrayList(metadata.getParameters().keySet()));
        result.setReturnsVoid(metadata.getResult() == null);
        result.setFiles(files);
        return result;
    }

    private void normalizeConfigure(LogicGenerateConfigure configure) {
        if (configure.getBackendExternalResolver() == null) {
            configure.setBackendExternalResolver((LogicBackendExternalResolver)new DefaultLogicBackendExternalResolver());
        }
        if (configure.getAllowCodeFormat() == null) {
            configure.setAllowCodeFormat(this.properties.getAllowCodeFormat());
        }
        configure.setAllowSourceMap(Boolean.valueOf(true));
        if (configure.getBackendAllowFieldShadowing() == null) {
            configure.setBackendAllowFieldShadowing(this.properties.getBackendAllowFieldShadowing());
        }
        if (configure.getAllowCheckPermission() == null) {
            configure.setAllowCheckPermission(Boolean.valueOf(false));
        }
    }

    private boolean shouldGenerateApiJs(LogicGenerateConfigure configure) {
        return configure.getPlatform() == LogicGenerationPlatform.LOW_CODE_PLATFORM && Optional.ofNullable(this.properties.getBackendGenerateApiJs()).orElse(true) != false;
    }

    private LogicGenerateFile generateService(LogicMetadata metadata, LogicGenerateSource source, LogicGenerateConfigure configure) {
        LogicBackendImportDefinition serviceClass = BackendClassNameUtils.parseQualifiedClass((String)BackendEngineClassNameUtils.serviceQualifiedClassOf(metadata, configure));
        BackendLogicEngineGenerateContext context = new BackendLogicEngineGenerateContext(metadata, configure, source.getRoot(), serviceClass.getQualifiedClassName());
        for (String string : SERVICE_INITIAL_IMPORTS) {
            context.addImport(string);
        }
        for (Map.Entry entry : SERVICE_INITIAL_FIELDS.entrySet()) {
            LogicBackendVariableDefinition definition = new LogicBackendVariableDefinition();
            definition.setName((String)entry.getKey());
            definition.setType(LogicBackendType.of((String)((String)entry.getValue())));
            context.addGlobalVariable(definition);
        }
        for (String string : SERVICE_INITIAL_METHODS) {
            context.addPredefinedMethod(string);
        }
        List parameters = metadata.getParameters().values().stream().map(arg_0 -> ((BackendLogicEngineGenerateContext)context).addVariable(arg_0)).collect(Collectors.toList());
        LogicBackendVariableDefinition logicBackendVariableDefinition = metadata.getResult() != null ? context.addVariable(metadata.getResult()) : null;
        LogicGeneratedCode body = context.generate(source.getRoot(), new Object[0]);
        String springContextHolderClassName = null;
        List services = context.getServices();
        if (services != null && services.size() > 0) {
            springContextHolderClassName = context.addImport(SERVICE_SPRING_CONTEXT_HOLDER_IMPORT);
        }
        List methods = context.getMethods();
        LinkedHashMap<String, LogicGeneratedCode> slots = new LinkedHashMap<String, LogicGeneratedCode>();
        slots.put("body", body);
        for (LogicBackendMethodDefinition method : methods) {
            slots.put("method_" + method.getName(), method.getBody());
        }
        LogicGeneratedCode raw = LogicRenderTemplate.begin((LogicGenerateContext)context, (LogicCanvasComponent)source.getRoot(), (String)SERVICE_TEMPLATE_PATH).parameter("className", (Object)serviceClass.getSimpleName()).parameter("packageName", (Object)serviceClass.getPackageName()).parameter("springContextHolderName", (Object)springContextHolderClassName).parameter("imports", (Object)context.getImports()).parameter("services", (Object)services).parameter("parameters", parameters).parameter("result", (Object)logicBackendVariableDefinition).parameter("methods", (Object)methods).slots(slots).render();
        LogicGeneratedCode code = this.formatBackendCode(raw, configure);
        LogicGenerateFile file = new LogicGenerateFile();
        file.setId(BackendEngineClassNameUtils.serviceQualifiedClassOf(context.getMetadata(), configure));
        file.setType(LogicGenerateFileType.SERVICE_STANDALONE);
        file.setPath(BackendEngineClassNameUtils.serviceFilePathOf(context.getMetadata(), configure));
        file.setContent(code.getCode());
        file.setSourceMap((byte[])Optional.ofNullable(code.getSourceMap()).map(LogicSourceMap::encode).orElse(null));
        return file;
    }

    private LogicGenerateFile generateApiJs(LogicMetadata metadata, LogicGenerateSource source, LogicGenerateConfigure configure) {
        String template;
        LogicSimpleGenerateContext context = new LogicSimpleGenerateContext(metadata, configure, source.getRoot());
        String logicName = BackendClassNameUtils.identifierToClassName((String)metadata.getName());
        String apiPath = BackendEngineClassNameUtils.apiHttpPathOf(metadata, configure);
        LogicGenerationFrontend frontend = Optional.ofNullable(configure.getFrontend()).orElse(LogicGenerationFrontend.WEB_FRONTEND);
        switch (frontend) {
            case WEB_FRONTEND: {
                template = API_WEB_TEMPLATE_PATH;
                break;
            }
            case MOBILE_FRONTEND: {
                template = API_MOBILE_TEMPLATE_PATH;
                break;
            }
            default: {
                throw new IllegalStateException("api frontend type not supported");
            }
        }
        LogicGeneratedCode code = LogicRenderTemplate.begin((LogicGenerateContext)context, (LogicCanvasComponent)source.getRoot(), (String)template).parameter("logicName", (Object)logicName).parameter("apiPath", (Object)apiPath).render();
        LogicGenerateFile file = new LogicGenerateFile();
        file.setId(BackendEngineClassNameUtils.apiJsImportPathOf(context.getMetadata(), configure));
        file.setType(LogicGenerateFileType.JS_API);
        file.setPath(BackendEngineClassNameUtils.apiJsFilePathOf(context.getMetadata(), configure));
        file.setContent(code.getCode());
        file.setSourceMap(null);
        return file;
    }

    private LogicGeneratedCode formatBackendCode(LogicGeneratedCode raw, LogicGenerateConfigure configure) {
        LogicGeneratedCode code;
        boolean allowCodeFormat = Optional.ofNullable(configure.getAllowCodeFormat()).orElse(true);
        boolean allowSourceMap = Optional.ofNullable(configure.getAllowSourceMap()).orElse(true);
        if (allowCodeFormat) {
            code = BackendCodeFormatUtils.format((LogicGeneratedCode)raw, (boolean)allowSourceMap);
        } else {
            code = new LogicGeneratedCode();
            code.setCode(raw.getCode());
            if (allowSourceMap) {
                if (code.getSourceMap() == null) {
                    throw new HussarLogicSourceMapException("missing source map");
                }
                code.setSourceMap(code.getSourceMap().optimize());
            }
        }
        return code;
    }

    static {
        SERVICE_INITIAL_FIELDS.put("logger", "org.slf4j.Logger");
        SERVICE_INITIAL_FIELDS.put("initialized", "java.lang.Boolean");
        SERVICE_INITIAL_METHODS = Arrays.asList("invoke", "invokeByMap", "initialize");
    }
}

