/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.modelinvoke;

import com.jxdinfo.hussar.logic.component.backend.modelinvoke.AbstractLogicBackendModelInvokeVisitor;
import com.jxdinfo.hussar.logic.component.backend.modelinvoke.dto.LogicBackendModelInvokePropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendFFIGenerateUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendLiteralUtils;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendVariableDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendInvokeConvention;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendMethodParameter;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendMethodReference;
import com.jxdinfo.hussar.logic.structure.resolve.service.LogicBackendServiceMethod;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaActualType;
import com.jxdinfo.hussar.logic.structure.resolve.type.JavaParameterizedType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.utils.LogicSupportUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.modelinvoke.logicBackendMvcModelInvokeVisitor", component="com.jxdinfo.logic.BackendDataModelInvoke", taints={"language:java", "platform:low_code", "runtime:mvc"})
public class LogicBackendMvcModelInvokeVisitor
extends AbstractLogicBackendModelInvokeVisitor {
    private static final String INVOKE_TEMPLATE_PATH = "/template/logic/backend/modelinvoke/mvc_invoke.ftl";
    private static final String ASSIGN_TEMPLATE_PATH = "/template/logic/backend/modelinvoke/mvc_assign.ftl";
    private static final String TRACE_LOG_MODEL_INVOKE_RETURNS_VALUE = "\u8c03\u7528\u6a21\u578b %s \u65b9\u6cd5 %s \u6210\u529f, \u8fd4\u56de = {}";
    private static final String TRACE_LOG_MODEL_INVOKE_RETURNS_VOID = "\u8c03\u7528\u6a21\u578b %s \u65b9\u6cd5 %s \u6210\u529f";

    /*
     * WARNING - void declaration
     */
    @Override
    protected LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendModelInvokePropsDto> component, LogicBackendMethodReference modelMethodReference, LogicBackendServiceMethod actualMethod, List<String> bindings, String resultName, LogicType resultType) {
        void var18_24;
        LogicCanvasComponent argumentComponent;
        LogicBackendInvokeConvention convention = Optional.ofNullable(actualMethod).map(LogicBackendServiceMethod::getInvokeConvention).orElseThrow(() -> new HussarLogicGenerateVisitorException("model invoke mvc missing invoke convention"));
        String modelServiceClass = Optional.of(actualMethod).map(LogicBackendServiceMethod::getMvcServiceClass).orElseThrow(() -> new HussarLogicGenerateVisitorException("model invoke service class is not resolved"));
        String modelMethodName = Optional.of(actualMethod).map(LogicBackendServiceMethod::getMvcServiceMethod).orElseThrow(() -> new HussarLogicGenerateVisitorException("model invoke method name is not resolved"));
        List modelMethodParameters = Optional.of(actualMethod).map(LogicBackendServiceMethod::getMvcParameters).orElseGet(Collections::emptyList);
        JavaActualType modelMethodReturnType = Optional.of(actualMethod).map(LogicBackendServiceMethod::getMvcReturnType).orElseThrow(() -> new HussarLogicGenerateVisitorException("model invoke method return type is not resolved"));
        if (convention != LogicBackendInvokeConvention.MVC) {
            throw new HussarLogicGenerateVisitorException("unsupported invoke convention for model invoke mvc: " + convention);
        }
        LinkedHashMap<String, Pair> modelMethodArguments = new LinkedHashMap<String, Pair>();
        LinkedHashMap modelSlotBindings = new LinkedHashMap();
        List modelParamNames = modelMethodParameters.stream().map(LogicBackendMethodParameter::getName).collect(Collectors.toList());
        for (int i = 0; i < modelParamNames.size(); ++i) {
            modelSlotBindings.put(modelParamNames.get(i), i < bindings.size() ? bindings.get(i) : (String)modelParamNames.get(i));
        }
        for (Object methodParameter : modelMethodParameters) {
            String string = methodParameter.getName();
            JavaActualType argumentType = methodParameter.getType();
            argumentComponent = component.getSingletonSlot((String)modelSlotBindings.get(string));
            if (argumentComponent == null) {
                throw new HussarLogicGenerateVisitorException("model invoke missing argument '" + string + "'");
            }
            modelMethodArguments.put(string, Pair.of((Object)argumentComponent, (Object)argumentType));
        }
        LinkedHashMap<String, LogicGeneratedCode> argumentSlots = new LinkedHashMap<String, LogicGeneratedCode>();
        for (Map.Entry entry : modelMethodArguments.entrySet()) {
            String slotName = "argument_" + (String)entry.getKey();
            argumentComponent = (LogicCanvasComponent)((Pair)entry.getValue()).getLeft();
            JavaActualType argumentType = (JavaActualType)((Pair)entry.getValue()).getRight();
            LogicGeneratedCode argumentSlot = context.generate(argumentComponent, new Object[]{LogicGenerateContextualHintFeature.EXPRESSION}).postprocess(BackendFFIGenerateUtils.intoJavaType((BackendLogicGenerateContext)context, (JavaActualType)argumentType));
            argumentSlots.put(slotName, argumentSlot);
        }
        String serviceName = context.addService(true, true, modelServiceClass);
        LogicGeneratedCode logicGeneratedCode = context.beginTemplate(INVOKE_TEMPLATE_PATH).parameter("serviceName", (Object)serviceName).parameter("methodName", (Object)modelMethodName).parameter("arguments", argumentSlots.keySet()).slots(argumentSlots).render();
        JavaActualType actualReturnType = modelMethodReturnType;
        if (modelMethodReturnType instanceof JavaParameterizedType && Objects.equals(((JavaParameterizedType)modelMethodReturnType).getRawType().getQualifiedClass(), ApiResponse.class.getName())) {
            actualReturnType = Optional.ofNullable(((JavaParameterizedType)modelMethodReturnType).getTypeParameters()).filter(args -> args.size() == 1).map(args -> (JavaActualType)args.get(0)).orElseThrow(() -> new HussarLogicGenerateVisitorException("failed to unwrap ApiResponse<T> to get actual T"));
            LogicGeneratedCode logicGeneratedCode2 = LogicGeneratedCode.concat((LogicGeneratedCode[])new LogicGeneratedCode[]{context.getCodeFragment(context.addImport(LogicSupportUtils.class.getName()) + ".unwrapApiResponse("), logicGeneratedCode, context.getCodeFragment(")")});
        }
        LogicGeneratedCode logicGeneratedCode3 = var18_24.postprocess(BackendFFIGenerateUtils.fromJavaType((BackendLogicGenerateContext)context, (JavaActualType)actualReturnType, (LogicType)resultType)).typed(resultType);
        LogicBackendVariableDefinition result = resultType != null ? context.addVariable(LogicVariableDefinition.of((String)resultName, (LogicType)resultType)) : null;
        boolean allowTraceLog = Optional.ofNullable(context.getConfigure()).map(LogicGenerateConfigure::getAllowTraceLogging).orElse(false);
        String traceLogger = null;
        String traceMessage = null;
        if (allowTraceLog) {
            traceLogger = (String)context.getAttribute("logger.symbol", String.class);
            traceMessage = String.format(resultType != null ? TRACE_LOG_MODEL_INVOKE_RETURNS_VALUE : TRACE_LOG_MODEL_INVOKE_RETURNS_VOID, modelMethodReference.getModelId(), modelMethodReference.getMethodName());
        }
        return context.beginTemplate(ASSIGN_TEMPLATE_PATH).parameter("result", (Object)result).parameter("logger", (Object)traceLogger).parameter("message", traceMessage).slot("invocation", logicGeneratedCode3).render();
    }

    protected LogicGeneratedCode traceLogging(BackendLogicGenerateContext context, LogicBackendMethodReference modelMethodReference, LogicBackendServiceMethod actualMethod, String resultName, LogicType resultType) {
        boolean allowTraceLog = Optional.ofNullable(context.getConfigure()).map(LogicGenerateConfigure::getAllowTraceLogging).orElse(false);
        if (!allowTraceLog) {
            return context.getCodeFragment("");
        }
        boolean returnsValue = resultName != null && resultType != null;
        String traceLogger = (String)context.getAttribute("logger.symbol", String.class);
        String traceMessage = String.format(returnsValue ? TRACE_LOG_MODEL_INVOKE_RETURNS_VALUE : TRACE_LOG_MODEL_INVOKE_RETURNS_VOID, modelMethodReference.getModelId(), modelMethodReference.getMethodName());
        if (StringUtils.isEmpty((CharSequence)traceLogger) || StringUtils.isEmpty((CharSequence)traceMessage)) {
            return context.getCodeFragment("");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(traceLogger).append(".trace(").append(BackendLiteralUtils.stringLiteralOf((BackendLogicGenerateContext)context, (String)traceMessage));
        if (returnsValue) {
            builder.append(", ").append(resultName);
        }
        builder.append(");\n");
        return context.getCodeFragment(builder.toString());
    }
}

