/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.whileloop;

import com.jxdinfo.hussar.logic.component.backend.whileloop.dto.LogicBackendWhilePropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendConditionUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationRuntime;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.utils.LogicSupportUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.whileloop.LogicBackendWhileVisitor", component="com.jxdinfo.logic.BackendWhile", taints={"language:java"})
public class LogicBackendWhileVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendWhilePropsDto> {
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendWhile";
    private static final String TEMPLATE_PATH = "/template/logic/backend/whileloop/whileloop.ftl";
    private static final String SLOT_DEFAULT = "default";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendWhilePropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.STATEMENT)) {
            throw new HussarLogicGenerateVisitorException("while is incompatible with non-statement context");
        }
        List conditions = Optional.ofNullable(component.getProps()).map(LogicBackendWhilePropsDto::getConditions).filter(CollectionUtils::isNotEmpty).orElseThrow(() -> new HussarLogicGenerateVisitorException("while missing conditions"));
        List whileComponents = Optional.ofNullable(component.getSlot(SLOT_DEFAULT)).orElseGet(Collections::emptyList);
        LogicGeneratedCode conditionSlot = BackendConditionUtils.renderConditionList((BackendLogicGenerateContext)context, (List)conditions);
        LinkedHashMap<String, LogicGeneratedCode> whileSlots = new LinkedHashMap<String, LogicGeneratedCode>();
        if (context.getConfigure().getRuntime() == LogicGenerationRuntime.ENGINE) {
            whileSlots.put("body_checkpoint", context.getCodeFragment(context.addImport(LogicSupportUtils.class.getName()) + ".checkpoint();"));
        }
        int whileIndex = 0;
        for (LogicCanvasComponent whileComponent : whileComponents) {
            LogicGeneratedCode whileSlot = context.generate(whileComponent, new Object[]{LogicGenerateContextualHintFeature.STATEMENT});
            whileSlots.put("while_" + whileIndex++, whileSlot);
        }
        return context.beginTemplate(TEMPLATE_PATH).parameter("whileSlots", whileSlots.keySet()).slot("conditionSlot", conditionSlot).slots(whileSlots).render();
    }
}

