/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.variable;

import com.jxdinfo.hussar.logic.component.backend.variable.dto.LogicBackendVariablePropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendVariableAccessUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicExpressionPropsDto;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.variable.logicBackendVariableVisitor", component="com.jxdinfo.logic.BackendVariable", taints={"language:java"})
public class LogicBackendVariableVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendVariablePropsDto> {
    private static final Logger logger = LoggerFactory.getLogger(LogicBackendVariableVisitor.class);
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendVariable";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendVariablePropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.EXPRESSION)) {
            throw new HussarLogicGenerateVisitorException("variable is incompatible with non-expression context");
        }
        List variable = Optional.ofNullable(component.getProps()).map(LogicBackendVariablePropsDto::getValue).filter(CollectionUtils::isNotEmpty).orElseThrow(() -> new HussarLogicGenerateVisitorException("variable missing source"));
        LogicType type = Optional.ofNullable(component.getProps()).map(BaseLogicExpressionPropsDto::getType).orElseThrow(() -> new HussarLogicGenerateVisitorException("variable missing type"));
        String name = (String)variable.get(0);
        if (context.getVariable(name) == null) {
            logger.warn("no such variable: {}", (Object)name);
        }
        return BackendVariableAccessUtils.renderVariableRead((BackendLogicGenerateContext)context, (List)variable, (LogicType)type);
    }
}

