/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.switchstmt;

import com.jxdinfo.hussar.logic.component.backend.switchstmt.dto.LogicBackendSwitchPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendConditionUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.switchstmt.logicBackendSwitchVisitor", component="com.jxdinfo.logic.BackendSwitch", taints={"language:java"})
public class LogicBackendSwitchVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendSwitchPropsDto> {
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendSwitch";
    private static final String TEMPLATE_PATH = "/template/logic/backend/switchstmt/switchstmt.ftl";
    private static final String OTHER = "other";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendSwitchPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.STATEMENT)) {
            throw new HussarLogicGenerateVisitorException("switch is incompatible with non-statement context");
        }
        Map conditions = Optional.ofNullable(component.getProps()).map(LogicBackendSwitchPropsDto::getCondition).filter(condition -> !condition.isEmpty()).orElseThrow(() -> new HussarLogicGenerateVisitorException("switch missing conditions"));
        List matchEntries = Optional.ofNullable(component.getProps()).map(LogicBackendSwitchPropsDto::getMatchEntries).filter(CollectionUtils::isNotEmpty).orElseThrow(() -> new HussarLogicGenerateVisitorException("switch missing matchEntries"));
        HashMap<String, LogicGeneratedCode> totalSlots = new HashMap<String, LogicGeneratedCode>();
        ArrayList<List> components = new ArrayList<List>();
        int i = 1;
        for (LogicBackendSwitchPropsDto.LogicBackendMatchEntriesDto entry : matchEntries) {
            if (entry.getSlot() == null) {
                throw new HussarLogicGenerateVisitorException("matchEntries of Switch missing slot");
            }
            List slot = component.getSlot(entry.getSlot());
            components.add(slot);
            List condition2 = (List)conditions.get(entry.getCondition());
            if (OTHER.equals(entry.getCondition())) continue;
            if (CollectionUtils.isEmpty((Collection)condition2)) {
                throw new HussarLogicGenerateVisitorException("Switch missing condition of" + entry.getCondition());
            }
            LogicGeneratedCode conditionSlot = BackendConditionUtils.renderConditionList((BackendLogicGenerateContext)context, (List)condition2);
            totalSlots.put("condition_" + i, conditionSlot);
            ++i;
        }
        Set<Object> elseSet = new HashSet();
        ArrayList<Pair> branchesPairs = new ArrayList<Pair>();
        i = 1;
        for (List componentList : components) {
            int index = 1;
            ArrayList<String> branchName = new ArrayList<String>();
            HashMap<String, LogicGeneratedCode> branchSlots = new HashMap<String, LogicGeneratedCode>();
            for (LogicCanvasComponent slot : componentList) {
                LogicGeneratedCode branchSlot = context.generate(slot, new Object[]{LogicGenerateContextualHintFeature.STATEMENT});
                totalSlots.put("branch" + i + "_item" + index, branchSlot);
                if (i == components.size()) {
                    branchSlots.put("branch" + i + "_item" + index, branchSlot);
                }
                if (index <= componentList.size()) {
                    branchName.add("branch" + i + "_item" + index);
                }
                ++index;
            }
            if (i < components.size()) {
                Pair branchesPair = Pair.of((Object)("condition_" + i), branchName);
                branchesPairs.add(branchesPair);
            } else {
                elseSet = branchSlots.keySet();
            }
            ++i;
        }
        return context.beginTemplate(TEMPLATE_PATH).parameter("elseSlots", elseSet).parameter("hasElse", (Object)(!elseSet.isEmpty() ? 1 : 0)).parameter("branchesPairs", branchesPairs).slots(totalSlots).render();
    }
}

