/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.start;

import com.jxdinfo.hussar.logic.component.backend.start.dto.LogicBackendStartPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendLiteralUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.definition.LogicVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.start.logicBackendStartVisitor", component="com.jxdinfo.logic.BackendStart", taints={"language:java"})
public class LogicBackendStartVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendStartPropsDto> {
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendStart";
    private static final String TRACE_LOG_LOGIC_START = "==> \u903b\u8f91 %s (%s) \u5f00\u59cb";
    private static final String TRACE_LOG_LOGIC_PARAMETERS = "--- \u903b\u8f91 %s (%s) \u5165\u53c2\u53d8\u91cf\u5217\u8868: ";
    private static final String TRACE_LOG_LOGIC_RESULT = "--- \u903b\u8f91 %s (%s) \u51fa\u53c2\u53d8\u91cf: ";
    private static final String TRACE_LOG_LOGIC_VARIABLES = "--- \u903b\u8f91 %s (%s) \u5c40\u90e8\u53d8\u91cf\u5217\u8868: ";
    private static final String TRACE_LOG_LOGIC_SYMBOL = "%s (%s) = {}";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendStartPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.STATEMENT)) {
            throw new HussarLogicGenerateVisitorException("start is incompatible with non-statement context");
        }
        String traceLogging = this.generateTraceLog(context);
        return context.getCodeFragment(traceLogging);
    }

    private String generateTraceLog(BackendLogicGenerateContext context) {
        Map variables;
        LogicVariableDefinition result;
        boolean allowTraceLog = Optional.ofNullable(context.getConfigure()).map(LogicGenerateConfigure::getAllowTraceLogging).orElse(false);
        if (!allowTraceLog) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String traceLogger = (String)context.getAttribute("logger.symbol", String.class);
        if (StringUtils.isEmpty((CharSequence)traceLogger)) {
            return "";
        }
        String startTraceMessage = String.format(TRACE_LOG_LOGIC_START, context.getMetadata().getTitle(), context.getMetadata().getName());
        builder.append(traceLogger).append(".trace(").append(BackendLiteralUtils.stringLiteralOf((BackendLogicGenerateContext)context, (String)startTraceMessage)).append(");\n");
        Map parameters = context.getMetadata().getParameters();
        if (MapUtils.isNotEmpty((Map)parameters)) {
            String traceMessage = String.format(TRACE_LOG_LOGIC_PARAMETERS, context.getMetadata().getTitle(), context.getMetadata().getName());
            traceMessage = traceMessage + parameters.values().stream().map(parameter -> String.format(TRACE_LOG_LOGIC_SYMBOL, parameter.getTitle(), parameter.getName())).collect(Collectors.joining(", "));
            builder.append(traceLogger).append(".trace(").append(BackendLiteralUtils.stringLiteralOf((BackendLogicGenerateContext)context, (String)traceMessage));
            for (LogicVariableDefinition parameter2 : parameters.values()) {
                builder.append(", ").append(parameter2.getName());
            }
            builder.append(");\n");
        }
        if ((result = context.getMetadata().getResult()) != null) {
            String traceMessage = String.format(TRACE_LOG_LOGIC_RESULT, context.getMetadata().getTitle(), context.getMetadata().getName());
            traceMessage = traceMessage + String.format(TRACE_LOG_LOGIC_SYMBOL, result.getTitle(), result.getName());
            builder.append(traceLogger).append(".trace(").append(BackendLiteralUtils.stringLiteralOf((BackendLogicGenerateContext)context, (String)traceMessage)).append(", ").append(result.getName()).append(");\n");
        }
        if (MapUtils.isNotEmpty((Map)(variables = context.getMetadata().getVariables()))) {
            String traceMessage = String.format(TRACE_LOG_LOGIC_VARIABLES, context.getMetadata().getTitle(), context.getMetadata().getName());
            traceMessage = traceMessage + variables.values().stream().map(variable -> String.format(TRACE_LOG_LOGIC_SYMBOL, variable.getTitle(), variable.getName())).collect(Collectors.joining(", "));
            builder.append(traceLogger).append(".trace(").append(BackendLiteralUtils.stringLiteralOf((BackendLogicGenerateContext)context, (String)traceMessage));
            for (LogicVariableDefinition variable2 : variables.values()) {
                builder.append(", ").append(variable2.getName());
            }
            builder.append(");\n");
        }
        return builder.toString();
    }
}

