/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.num;

import com.jxdinfo.hussar.logic.component.backend.num.dto.LogicBackendNumberPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicExpressionPropsDto;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LogicGenerateVisitorService(value="ccom.jxdinfo.hussar.logic.component.backend.num.logicBackendNumberVisitor", component="com.jxdinfo.logic.BackendNum", taints={"language:java"})
public class LogicBackendNumberVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendNumberPropsDto> {
    public static final Logger logger = LoggerFactory.getLogger(LogicBackendNumberVisitor.class);
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendNum";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendNumberPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.EXPRESSION)) {
            throw new HussarLogicGenerateVisitorException("number is incompatible with non-expression context");
        }
        String value = Optional.ofNullable(component.getProps()).map(LogicBackendNumberPropsDto::getValue).orElse("");
        LogicType type = Optional.ofNullable(component.getProps()).map(BaseLogicExpressionPropsDto::getType).orElse(null);
        if (type == null) {
            logger.warn("missing number type, auto choose a type: {}", (Object)component.getInstanceKey());
            type = StringUtils.endsWithIgnoreCase((CharSequence)value, (CharSequence)"L") ? LogicType.LONG : (StringUtils.endsWithIgnoreCase((CharSequence)value, (CharSequence)"D") ? LogicType.DOUBLE : LogicType.INTEGER);
        }
        String literal = context.getLiteralOf(context.addType(type), value);
        return context.getCodeFragment(literal).typed(type);
    }
}

