/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.newobject;

import com.jxdinfo.hussar.logic.component.backend.newobject.AbstractLogicBackendNewVisitor;
import com.jxdinfo.hussar.logic.component.backend.newobject.dto.LogicBackendNewStructurePropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendTypeReferenceUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendVariableAccessUtils;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.fieldmapping.LogicFieldMapping;
import com.jxdinfo.hussar.logic.structure.fieldmapping.LogicFieldSource;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationPlatform;
import com.jxdinfo.hussar.logic.structure.type.LogicBackendType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicExpressionPropsDto;
import com.jxdinfo.hussar.logic.utils.LogicSupportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.newobject.logicBackendNewStructureVisitor", component="com.jxdinfo.logic.BackendNew", taints={"language:java"})
public class LogicBackendNewStructureVisitor
extends AbstractLogicBackendNewVisitor<LogicBackendNewStructurePropsDto> {
    private static final String ENTITY_CREATE_TEMPLATE_PATH = "/template/logic/backend/newobject/entity_create.ftl";
    private static final String ENTITY_BUILD_TEMPLATE_PATH = "/template/logic/backend/newobject/entity_build.ftl";
    private static final String ENTITY_BUILD_EAI_TEMPLATE_PATH = "/template/logic/backend/newobject/entity_build_eai.ftl";
    private static final String ENTITY_DYNAMIC_TEMPLATE_PATH = "/template/logic/backend/newobject/entity_dynamic.ftl";

    @Override
    protected String getNewComponentKind() {
        return "structure";
    }

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendNewStructurePropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.EXPRESSION)) {
            throw new HussarLogicGenerateVisitorException("new structure is incompatible with non-expression context");
        }
        List mappings = Optional.ofNullable(component.getProps()).map(LogicBackendNewStructurePropsDto::getMapping).orElseGet(Collections::emptyList);
        LogicType type = Optional.ofNullable(component.getProps()).map(BaseLogicExpressionPropsDto::getType).orElseThrow(() -> new HussarLogicGenerateVisitorException("new structure missing target type"));
        LogicBackendType actualType = context.addType(type);
        if (this.isDynamicEntity(actualType)) {
            return this.generateDynamic(context, mappings, actualType).typed(type);
        }
        return this.generateEntity(context, mappings, actualType).typed(type);
    }

    private LogicGeneratedCode generateEntity(BackendLogicGenerateContext context, List<LogicFieldMapping> mappings, LogicBackendType type) {
        String logicSupportUtilsClassName = context.addImport(LogicSupportUtils.class.getName());
        LogicGeneratedCode targetTypeReference = BackendTypeReferenceUtils.renderTypeReference((BackendLogicGenerateContext)context, (LogicBackendType)type);
        if (CollectionUtils.isEmpty(mappings)) {
            return context.beginTemplate(ENTITY_CREATE_TEMPLATE_PATH).parameter("logicSupportUtilsName", (Object)logicSupportUtilsClassName).slot("targetType", targetTypeReference).render();
        }
        if (context.getConfigure().getPlatform() != LogicGenerationPlatform.EAI_PLATFORM) {
            PropertiesRenderResult properties = this.renderProperties(context, mappings);
            String rawTypeName = context.addImport(type.getQualifiedClass());
            return context.beginTemplate(ENTITY_BUILD_TEMPLATE_PATH).parameter("logicSupportUtilsName", (Object)logicSupportUtilsClassName).parameter("rawTypeName", (Object)rawTypeName).parameter("properties", properties.getNames()).slot("targetType", targetTypeReference).slots(properties.getSlots()).render();
        }
        PropertiesRenderResult properties = this.renderProperties(context, mappings);
        String rawTypeName = context.addImport(type.getQualifiedClass());
        return context.beginTemplate(ENTITY_BUILD_EAI_TEMPLATE_PATH).parameter("logicSupportUtilsName", (Object)logicSupportUtilsClassName).parameter("rawTypeName", (Object)rawTypeName).parameter("properties", properties.getNames()).slot("targetType", targetTypeReference).slots(properties.getSlots()).render();
    }

    private LogicGeneratedCode generateDynamic(BackendLogicGenerateContext context, List<LogicFieldMapping> mappings, LogicBackendType type) {
        PropertiesRenderResult properties = this.renderProperties(context, mappings);
        String logicSupportUtilsClassName = context.addImport(LogicSupportUtils.class.getName());
        return context.beginTemplate(ENTITY_DYNAMIC_TEMPLATE_PATH).parameter("logicSupportUtilsName", (Object)logicSupportUtilsClassName).parameter("properties", properties.getNames()).slots(properties.getSlots()).render();
    }

    private PropertiesRenderResult renderProperties(BackendLogicGenerateContext context, List<LogicFieldMapping> mappings) {
        int i = 0;
        ArrayList<Pair<String, String>> propertyNames = new ArrayList<Pair<String, String>>();
        LinkedHashMap<String, LogicGeneratedCode> propertySlots = new LinkedHashMap<String, LogicGeneratedCode>();
        for (LogicFieldMapping mapping : mappings) {
            if (BackendVariableAccessUtils.isInvalidFieldMapping((LogicFieldMapping)mapping)) continue;
            LogicGeneratedCode valueSlot = BackendVariableAccessUtils.renderFieldSource((BackendLogicGenerateContext)context, (LogicFieldSource)mapping.getSource());
            List targetVariable = mapping.getTarget().getVariable();
            if (CollectionUtils.size((Object)targetVariable) != 2 || !Objects.equals(targetVariable.get(0), "_")) {
                throw new HussarLogicGenerateVisitorException("illegal new structure target variable: " + targetVariable);
            }
            String propertyName = (String)targetVariable.get(1);
            String slotName = "property_" + i++;
            propertyNames.add((Pair<String, String>)Pair.of((Object)propertyName, (Object)slotName));
            propertySlots.put(slotName, valueSlot);
        }
        PropertiesRenderResult result = new PropertiesRenderResult();
        result.setNames(propertyNames);
        result.setSlots(propertySlots);
        return result;
    }

    private boolean isDynamicEntity(LogicBackendType type) {
        if (type == null || !Objects.equals(type.getQualifiedClass(), "java.util.Map")) {
            return false;
        }
        List typeArguments = type.getTypeArguments();
        if (CollectionUtils.isEmpty((Collection)typeArguments)) {
            return true;
        }
        if (CollectionUtils.size((Object)typeArguments) != 2) {
            return false;
        }
        LogicBackendType keyType = (LogicBackendType)typeArguments.get(0);
        LogicBackendType valueType = (LogicBackendType)typeArguments.get(1);
        return keyType != null && valueType != null && CollectionUtils.isEmpty((Collection)keyType.getTypeArguments()) && CollectionUtils.isEmpty((Collection)valueType.getTypeArguments()) && Objects.equals(keyType.getQualifiedClass(), "java.lang.String") && Objects.equals(valueType.getQualifiedClass(), "java.lang.Object");
    }

    public static final class PropertiesRenderResult {
        private List<Pair<String, String>> names;
        private Map<String, LogicGeneratedCode> slots;

        public List<Pair<String, String>> getNames() {
            return this.names;
        }

        public void setNames(List<Pair<String, String>> names) {
            this.names = names;
        }

        public Map<String, LogicGeneratedCode> getSlots() {
            return this.slots;
        }

        public void setSlots(Map<String, LogicGeneratedCode> slots) {
            this.slots = slots;
        }
    }
}

