/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.newobject;

import com.jxdinfo.hussar.logic.component.backend.newobject.AbstractLogicBackendNewVisitor;
import com.jxdinfo.hussar.logic.component.backend.newobject.dto.LogicBackendNewMapPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.type.LogicBackendType;
import com.jxdinfo.hussar.logic.structure.type.LogicBuiltinType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicExpressionPropsDto;
import com.jxdinfo.hussar.logic.utils.LogicSupportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.newobject.logicBackendNewMapVisitor", component="com.jxdinfo.logic.BackendNew", taints={"language:java"})
public class LogicBackendNewMapVisitor
extends AbstractLogicBackendNewVisitor<LogicBackendNewMapPropsDto> {
    private static final String TEMPLATE_PATH = "/template/logic/backend/newobject/map.ftl";

    @Override
    protected String getNewComponentKind() {
        return "map";
    }

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendNewMapPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.EXPRESSION)) {
            throw new HussarLogicGenerateVisitorException("new map is incompatible with non-expression context");
        }
        LogicType keyType = Optional.ofNullable(component.getProps()).map(LogicBackendNewMapPropsDto::getMapKeyType).orElseThrow(() -> new HussarLogicGenerateVisitorException("new map missing key type"));
        LogicType valueType = Optional.ofNullable(component.getProps()).map(LogicBackendNewMapPropsDto::getMapValueType).orElseThrow(() -> new HussarLogicGenerateVisitorException("new map missing value type"));
        LogicType type = Optional.ofNullable(component.getProps()).map(BaseLogicExpressionPropsDto::getType).orElseGet(() -> LogicType.of((LogicBuiltinType)LogicBuiltinType.MAP, (LogicType[])new LogicType[]{keyType, valueType}));
        List mapEntries = Optional.ofNullable(component.getProps()).map(LogicBackendNewMapPropsDto::getMapEntries).orElseGet(Collections::emptyList);
        int i = 0;
        LinkedHashMap<String, LogicCanvasComponent> childComponents = new LinkedHashMap<String, LogicCanvasComponent>();
        ArrayList<Pair> entryNames = new ArrayList<Pair>();
        for (Object mapEntry : mapEntries) {
            if (mapEntry == null) {
                throw new HussarLogicGenerateVisitorException("new map contains null entry");
            }
            LogicCanvasComponent logicCanvasComponent = component.getSingletonSlot(((LogicBackendNewMapPropsDto.LogicBackendNewMapEntryDto)mapEntry).getKey());
            LogicCanvasComponent valueComponent = component.getSingletonSlot(((LogicBackendNewMapPropsDto.LogicBackendNewMapEntryDto)mapEntry).getValue());
            if (logicCanvasComponent == null) {
                throw new HussarLogicGenerateVisitorException("new list missing key slot: " + ((LogicBackendNewMapPropsDto.LogicBackendNewMapEntryDto)mapEntry).getKey());
            }
            if (valueComponent == null) {
                throw new HussarLogicGenerateVisitorException("new list missing value slot: " + ((LogicBackendNewMapPropsDto.LogicBackendNewMapEntryDto)mapEntry).getValue());
            }
            int index = i++;
            String keySlotName = "key_" + index;
            String valueSlotName = "value_" + index;
            childComponents.put(keySlotName, logicCanvasComponent);
            childComponents.put(valueSlotName, valueComponent);
            entryNames.add(Pair.of((Object)keySlotName, (Object)valueSlotName));
        }
        LinkedHashMap childSlots = new LinkedHashMap();
        for (Map.Entry entry : childComponents.entrySet()) {
            LogicGeneratedCode childComponent = context.generate((LogicCanvasComponent)entry.getValue(), new Object[]{LogicGenerateContextualHintFeature.EXPRESSION});
            childSlots.put(entry.getKey(), childComponent);
        }
        String logicSupportUtilsClassName = context.addImport(LogicSupportUtils.class.getName());
        LogicBackendType logicBackendType = context.addType(keyType);
        LogicBackendType valueBackendType = context.addType(valueType);
        return context.beginTemplate(TEMPLATE_PATH).parameter("logicSupportUtilsName", (Object)logicSupportUtilsClassName).parameter("keyType", (Object)logicBackendType).parameter("valueType", (Object)valueBackendType).parameter("entries", entryNames).slots(childSlots).render().typed(type);
    }
}

