/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.newobject;

import com.jxdinfo.hussar.logic.component.backend.newobject.AbstractLogicBackendNewVisitor;
import com.jxdinfo.hussar.logic.component.backend.newobject.dto.LogicBackendNewListPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.type.LogicBackendType;
import com.jxdinfo.hussar.logic.structure.type.LogicBuiltinType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicExpressionPropsDto;
import com.jxdinfo.hussar.logic.utils.LogicSupportUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.newobject.logicBackendNewListVisitor", component="com.jxdinfo.logic.BackendNew", taints={"language:java"})
public class LogicBackendNewListVisitor
extends AbstractLogicBackendNewVisitor<LogicBackendNewListPropsDto> {
    private static final String TEMPLATE_PATH = "/template/logic/backend/newobject/list.ftl";
    private static final String SLOT_LIST = "expressionList";

    @Override
    protected String getNewComponentKind() {
        return "list";
    }

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendNewListPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.EXPRESSION)) {
            throw new HussarLogicGenerateVisitorException("new list is incompatible with non-expression context");
        }
        LogicType itemType = Optional.ofNullable(component.getProps()).map(LogicBackendNewListPropsDto::getListItemType).orElseThrow(() -> new HussarLogicGenerateVisitorException("new list missing item type"));
        LogicType type = Optional.ofNullable(component.getProps()).map(BaseLogicExpressionPropsDto::getType).orElseGet(() -> LogicType.of((LogicBuiltinType)LogicBuiltinType.LIST, (LogicType[])new LogicType[]{itemType}));
        int i = 0;
        LinkedHashMap<String, Object> itemComponents = new LinkedHashMap<String, Object>();
        for (Object itemComponent : component.getSlot(SLOT_LIST)) {
            itemComponents.put("item_" + i++, itemComponent);
        }
        LinkedHashMap itemSlots = new LinkedHashMap();
        for (Map.Entry entry : itemComponents.entrySet()) {
            LogicGeneratedCode itemSlot = context.generate((LogicCanvasComponent)entry.getValue(), new Object[]{LogicGenerateContextualHintFeature.EXPRESSION});
            itemSlots.put(entry.getKey(), itemSlot);
        }
        String logicSupportUtilsClassName = context.addImport(LogicSupportUtils.class.getName());
        LogicBackendType logicBackendType = context.addType(itemType);
        return context.beginTemplate(TEMPLATE_PATH).parameter("logicSupportUtilsName", (Object)logicSupportUtilsClassName).parameter("itemType", (Object)logicBackendType).parameter("items", itemSlots.keySet()).slots(itemSlots).render().typed(type);
    }
}

