/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.logicinvoke;

import com.jxdinfo.hussar.logic.component.backend.logicinvoke.dto.LogicBackendLogicInvokePropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendClassNameUtils;
import com.jxdinfo.hussar.logic.generator.utils.LogicCanvasConvertUtils;
import com.jxdinfo.hussar.logic.generator.utils.LogicTypeCheckUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasVariable;
import com.jxdinfo.hussar.logic.structure.definition.LogicVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.resolve.logic.LogicReference;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicExpressionPropsDto;
import com.jxdinfo.hussar.logic.utils.LogicPathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogicBackendLogicInvokeVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendLogicInvokePropsDto> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLogicBackendLogicInvokeVisitor.class);
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendLogicInvoke";
    protected static final String SERVICE_CLASS_NAME_SUFFIX = "Service";
    private static final String TRACE_LOG_EXPLANATION = "%s (%s) \u903b\u8f91\u8c03\u7528";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendLogicInvokePropsDto> component) {
        String logic = Optional.ofNullable(component.getProps()).map(LogicBackendLogicInvokePropsDto::getLogic).orElseThrow(() -> new HussarLogicGenerateVisitorException("logic invoke missing target logic reference"));
        List bindings = Optional.ofNullable(component.getProps()).map(LogicBackendLogicInvokePropsDto::getBindings).orElseGet(Collections::emptyList);
        LogicType type = Optional.ofNullable(component.getProps()).map(BaseLogicExpressionPropsDto::getType).orElse(null);
        LogicReference logicReference = context.getExternalResolver().resolveLogic(logic, context.getConfigure());
        if (logicReference == null) {
            throw new HussarLogicGenerateVisitorException("failed to resolve external logic: " + logic);
        }
        String logicQualifiedClass = this.referencedLogicQualifiedClassOf(context.getConfigure(), logicReference);
        Map logicParams = Optional.ofNullable(LogicCanvasConvertUtils.convertVariableList((List)logicReference.getParams())).orElseGet(Collections::emptyMap);
        LogicVariableDefinition logicResult = LogicCanvasConvertUtils.convertVariable((LogicCanvasVariable)Optional.ofNullable(logicReference.getResult()).filter(CollectionUtils::isNotEmpty).map(result -> (LogicCanvasVariable)result.get(0)).orElse(null));
        LogicType logicResultType = Optional.ofNullable(logicResult).map(LogicVariableDefinition::getType).orElse(null);
        LinkedHashMap<String, LogicCanvasComponent> logicParamComponents = new LinkedHashMap<String, LogicCanvasComponent>();
        LinkedHashMap logicSlotBindings = new LinkedHashMap();
        ArrayList logicParamNames = new ArrayList(logicParams.keySet());
        for (int i = 0; i < logicParamNames.size(); ++i) {
            logicSlotBindings.put(logicParamNames.get(i), i < bindings.size() ? (String)bindings.get(i) : (String)logicParamNames.get(i));
        }
        for (Object paramName : logicParams.keySet()) {
            LogicCanvasComponent logicCanvasComponent = component.getSingletonSlot((String)logicSlotBindings.get(paramName));
            if (logicCanvasComponent == null) {
                throw new HussarLogicGenerateVisitorException("logic invoke missing parameter '" + (String)paramName + "': " + logicReference);
            }
            logicParamComponents.put("slot_" + (String)paramName, logicCanvasComponent);
        }
        if (logicResultType != null && type != null && !LogicTypeCheckUtils.isAssignableFrom((LogicType)type, (LogicType)logicResultType)) {
            logger.warn("mismatched return type: {} <=> {}", (Object)type, (Object)logicReference);
        }
        LinkedHashMap<String, LogicGeneratedCode> logicParamSlots = new LinkedHashMap<String, LogicGeneratedCode>();
        for (Map.Entry entry : logicParamComponents.entrySet()) {
            LogicGeneratedCode logicParamSlot = context.generate((LogicCanvasComponent)entry.getValue(), new Object[]{LogicGenerateContextualHintFeature.EXPRESSION});
            logicParamSlots.put((String)entry.getKey(), logicParamSlot);
        }
        String traceExplanation = String.format(TRACE_LOG_EXPLANATION, logicReference.getTitle(), logicReference.getName());
        return this.generate(context, component, logicQualifiedClass, logicParamSlots, logicResultType, traceExplanation);
    }

    protected abstract LogicGeneratedCode generate(BackendLogicGenerateContext var1, LogicGenerateComponent<LogicBackendLogicInvokePropsDto> var2, String var3, Map<String, LogicGeneratedCode> var4, LogicType var5, String var6);

    protected String referencedLogicQualifiedClassOf(LogicGenerateConfigure configure, LogicReference logic) {
        return LogicPathUtils.packagePath((String[])new String[]{configure.getBackendPrefixPackage(), String.join((CharSequence)".", Optional.ofNullable(logic.getModules()).orElse(Collections.emptyList())), StringUtils.lowerCase((String)logic.getName()), configure.getBackendServiceInterfacePackage()}) + "." + this.referencedLogicClassNameOf(logic);
    }

    protected String referencedLogicClassNameOf(LogicReference logic) {
        return BackendClassNameUtils.identifierToClassName((String)logic.getName()) + SERVICE_CLASS_NAME_SUFFIX;
    }
}

