/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.log;

import com.jxdinfo.hussar.logic.component.backend.log.dto.LogicBackendLogPropsDto;
import com.jxdinfo.hussar.logic.component.backend.text.dto.LogicBackendTextPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.LogicComponentConvertUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.event.Level;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.log.logicBackendLogVisitor", component="com.jxdinfo.logic.BackendLog", taints={"language:java"})
public class LogicBackendLogVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendLogPropsDto> {
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendLog";
    private static final String TEMPLATE_PATH = "/template/logic/backend/log/log.ftl";
    private static final String SLF4J_DELIM = "{}";
    private static final String SLF4J_ESCAPE = "\\";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendLogPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.STATEMENT)) {
            throw new HussarLogicGenerateVisitorException("log is incompatible with non-statement context");
        }
        Level level = Optional.ofNullable(component.getProps()).map(LogicBackendLogPropsDto::getLevel).map(LogicBackendLogVisitor::parseLevel).orElseThrow(() -> new HussarLogicGenerateVisitorException("log missing level"));
        List itemComponents = Optional.ofNullable(component.getSlot("default")).orElseGet(Collections::emptyList);
        int i = 0;
        StringBuilder message = new StringBuilder();
        LinkedHashMap<String, LogicGeneratedCode> slots = new LinkedHashMap<String, LogicGeneratedCode>();
        for (LogicCanvasComponent itemComponent : itemComponents) {
            LogicGenerateComponent textComponent;
            String value;
            if (itemComponent == null) continue;
            if (Objects.equals(itemComponent.getName(), "com.jxdinfo.logic.BackendText") && LogicBackendLogVisitor.isInlineSafe(value = Optional.ofNullable((textComponent = LogicComponentConvertUtils.convertComponent((LogicCanvasComponent)itemComponent, LogicBackendTextPropsDto.class)).getProps()).map(LogicBackendTextPropsDto::getValue).orElse(""))) {
                message.append(value);
                continue;
            }
            LogicGeneratedCode slot = context.generate(itemComponent, new Object[]{LogicGenerateContextualHintFeature.EXPRESSION});
            message.append(SLF4J_DELIM);
            slots.put("item_" + i++, slot);
        }
        String loggerSymbol = (String)context.getAttribute("logger.symbol", String.class);
        if (StringUtils.isEmpty((CharSequence)loggerSymbol)) {
            throw new HussarLogicGenerateVisitorException("cannot generate log: no registered Logger");
        }
        String loggerMethod = level.toString().toLowerCase();
        return context.beginTemplate(TEMPLATE_PATH).parameter("logger", (Object)loggerSymbol).parameter("method", (Object)loggerMethod).parameter("message", (Object)message.toString()).parameter("arguments", slots.keySet()).slots(slots).render();
    }

    private static Level parseLevel(String level) {
        if (StringUtils.isEmpty((CharSequence)level)) {
            return null;
        }
        switch (level.toUpperCase()) {
            case "TRACE": {
                return Level.TRACE;
            }
            case "DEBUG": {
                return Level.DEBUG;
            }
            case "INFO": {
                return Level.INFO;
            }
            case "WARN": {
                return Level.WARN;
            }
            case "ERROR": {
                return Level.ERROR;
            }
        }
        throw new HussarLogicGenerateVisitorException("invalid log level: " + level);
    }

    private static boolean isInlineSafe(String value) {
        if (StringUtils.contains((CharSequence)value, (CharSequence)SLF4J_DELIM)) {
            return false;
        }
        return !StringUtils.endsWith((CharSequence)value, (CharSequence)SLF4J_ESCAPE);
    }
}

