/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.listassign;

import com.jxdinfo.hussar.logic.component.backend.listassign.dto.LogicBackendListAssignPropsDto;
import com.jxdinfo.hussar.logic.component.backend.listassign.dto.LogicVariableReferenceDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendTypeReferenceUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendVariableAccessUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendVariableDefinition;
import com.jxdinfo.hussar.logic.structure.fieldmapping.LogicFieldMapping;
import com.jxdinfo.hussar.logic.structure.fieldmapping.LogicFieldSource;
import com.jxdinfo.hussar.logic.structure.fieldmapping.LogicFieldTarget;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.type.LogicBuiltinType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.utils.LogicSupportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.listassign.logicBackendListAssignVisitor", component="com.jxdinfo.logic.BackendListAssign", taints={"language:java"})
public class LogicBackendListAssignVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendListAssignPropsDto> {
    private static final Logger logger = LoggerFactory.getLogger(LogicBackendListAssignVisitor.class);
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendListAssign";
    private static final String TEMPLATE_PATH = "/template/logic/backend/listassign/listassign.ftl";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendListAssignPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.STATEMENT)) {
            throw new HussarLogicGenerateVisitorException("list assign is incompatible with non-statement context");
        }
        List<LogicFieldMapping> rawMappings = Optional.ofNullable(component.getProps()).map(LogicBackendListAssignPropsDto::getMapping).orElse(Collections.emptyList());
        String targetVariableName = Optional.ofNullable(component.getProps()).map(LogicBackendListAssignPropsDto::getTargetVariable).map(LogicVariableReferenceDto::getName).orElseThrow(() -> new HussarLogicGenerateVisitorException("list assign missing target variable name"));
        String sourceVariableName = Optional.ofNullable(component.getProps()).map(LogicBackendListAssignPropsDto::getSourceVariables).filter(CollectionUtils::isNotEmpty).map(sourceVariables -> (LogicVariableReferenceDto)sourceVariables.get(0)).map(LogicVariableReferenceDto::getName).orElseThrow(() -> new HussarLogicGenerateVisitorException("list assign missing source variable name"));
        LogicType targetItemType = Optional.ofNullable(component.getProps()).map(LogicBackendListAssignPropsDto::getTargetVariable).map(LogicVariableReferenceDto::getType).map(LogicBackendListAssignVisitor::extractListItemType).orElseThrow(() -> new HussarLogicGenerateVisitorException("list assign missing target variable type"));
        LogicType sourceItemType = Optional.ofNullable(component.getProps()).map(LogicBackendListAssignPropsDto::getSourceVariables).filter(CollectionUtils::isNotEmpty).map(sourceVariables -> (LogicVariableReferenceDto)sourceVariables.get(0)).map(LogicVariableReferenceDto::getType).map(LogicBackendListAssignVisitor::extractListItemType).orElseThrow(() -> new HussarLogicGenerateVisitorException("list assign missing source variable type"));
        List<LogicFieldMapping> mappings = this.normalizeMappings(rawMappings, targetVariableName, sourceVariableName);
        boolean allowTraceLog = Optional.ofNullable(context.getConfigure()).map(LogicGenerateConfigure::getAllowTraceLogging).orElse(false);
        return (LogicGeneratedCode)context.withLocalScope(() -> {
            LogicBackendVariableDefinition targetItemVariable = context.addTemporaryVariable(targetVariableName + "Item", targetItemType);
            LogicBackendVariableDefinition sourceItemVariable = context.addTemporaryVariable(sourceVariableName + "Item", sourceItemType);
            for (LogicFieldMapping mapping : mappings) {
                List targetVariable = mapping.getTarget().getVariable();
                List sourceVariable = mapping.getSource().getVariable();
                targetVariable.set(0, targetItemVariable.getName());
                if (sourceVariable == null) continue;
                sourceVariable.set(0, sourceItemVariable.getName());
            }
            LogicGeneratedCode assignments = BackendVariableAccessUtils.renderFieldMappings((BackendLogicGenerateContext)context, (List)mappings, (boolean)allowTraceLog);
            String arrayListClassName = context.addImport(ArrayList.class.getName());
            String logicSupportUtilsClassName = context.addImport(LogicSupportUtils.class.getName());
            LogicGeneratedCode targetItemTypeReference = BackendTypeReferenceUtils.renderTypeReference((BackendLogicGenerateContext)context, (LogicType)targetItemType);
            return context.beginTemplate(TEMPLATE_PATH).parameter("arrayListName", (Object)arrayListClassName).parameter("logicSupportUtilsName", (Object)logicSupportUtilsClassName).parameter("sourceVar", (Object)sourceVariableName).parameter("targetVar", (Object)targetVariableName).parameter("sourceItem", (Object)sourceItemVariable).parameter("targetItem", (Object)targetItemVariable).slot("targetItemType", targetItemTypeReference).slot("assignments", assignments).render();
        });
    }

    private List<LogicFieldMapping> normalizeMappings(List<LogicFieldMapping> rawMappings, String targetVariableName, String sourceVariableName) {
        ArrayList<LogicFieldMapping> mappings = new ArrayList<LogicFieldMapping>();
        for (LogicFieldMapping rawMapping : rawMappings) {
            if (rawMapping == null || rawMapping.getTarget() == null || rawMapping.getSource() == null) continue;
            ArrayList targetVariable = rawMapping.getTarget().getVariable();
            String sourceCategory = rawMapping.getSource().getDataSource();
            List sourceVariable = rawMapping.getSource().getVariable();
            if (CollectionUtils.isEmpty((Collection)targetVariable) || StringUtils.isEmpty((CharSequence)sourceCategory)) continue;
            if (!Objects.equals(targetVariable.get(0), targetVariableName)) {
                logger.warn("illegal list assign mapping target: {}, expects {}", (Object)targetVariable, (Object)targetVariableName);
                continue;
            }
            LogicFieldTarget target = new LogicFieldTarget();
            target.setType(rawMapping.getTarget().getType());
            targetVariable = new ArrayList(targetVariable);
            target.setVariable(new ArrayList(targetVariable));
            LogicFieldSource source = new LogicFieldSource();
            source.setDataSource(sourceCategory);
            if (Objects.equals(sourceCategory, "variable")) {
                if (CollectionUtils.isEmpty((Collection)sourceVariable)) continue;
                if (!Objects.equals(sourceVariable.get(0), sourceVariableName)) {
                    logger.warn("illegal list assign mapping source: {}, expects {}", (Object)sourceVariable, (Object)sourceVariableName);
                    continue;
                }
                source.setVariable(new ArrayList(sourceVariable));
                source.setType(rawMapping.getSource().getType());
            } else {
                source.setConfigData(rawMapping.getSource().getConfigData());
                source.setType(rawMapping.getSource().getType());
            }
            LogicFieldMapping mapping = new LogicFieldMapping();
            mapping.setTarget(target);
            mapping.setSource(source);
            mappings.add(mapping);
        }
        return mappings;
    }

    private static LogicType extractListItemType(LogicType listType) {
        if (listType == null || !listType.isBuiltin() || listType.getBuiltinTypeName() != LogicBuiltinType.LIST || CollectionUtils.size((Object)listType.getTypeArguments()) != 1) {
            throw new HussarLogicGenerateVisitorException(listType + " mismatched list<T>");
        }
        return (LogicType)listType.getTypeArguments().get(0);
    }
}

