/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.ifstmt;

import com.jxdinfo.hussar.logic.component.backend.ifstmt.dto.LogicBackendIfPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendConditionUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.ifstmt.logicBackendIfVisitor", component="com.jxdinfo.logic.BackendIf", taints={"language:java"})
public class LogicBackendIfVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendIfPropsDto> {
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendIf";
    private static final String TEMPLATE_PATH = "/template/logic/backend/ifstmt/ifstmt.ftl";
    private static final String SLOT_IF = "if";
    private static final String SLOT_ELSE = "else";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendIfPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.STATEMENT)) {
            throw new HussarLogicGenerateVisitorException("if is incompatible with non-statement context");
        }
        List conditions = Optional.ofNullable(component.getProps()).map(LogicBackendIfPropsDto::getConditions).filter(CollectionUtils::isNotEmpty).orElseThrow(() -> new HussarLogicGenerateVisitorException("if missing conditions"));
        List ifComponents = Optional.ofNullable(component.getSlot(SLOT_IF)).orElseGet(Collections::emptyList);
        List elseComponents = Optional.ofNullable(component.getSlot(SLOT_ELSE)).orElseGet(Collections::emptyList);
        LogicGeneratedCode conditionSlot = BackendConditionUtils.renderConditionList((BackendLogicGenerateContext)context, (List)conditions);
        LinkedHashMap<String, LogicGeneratedCode> ifSlots = new LinkedHashMap<String, LogicGeneratedCode>();
        int ifIndex = 0;
        for (LogicCanvasComponent ifComponent : ifComponents) {
            LogicGeneratedCode ifSlot = context.generate(ifComponent, new Object[]{LogicGenerateContextualHintFeature.STATEMENT});
            ifSlots.put("if_" + ifIndex++, ifSlot);
        }
        LinkedHashMap<String, LogicGeneratedCode> elseSlots = new LinkedHashMap<String, LogicGeneratedCode>();
        int elseIndex = 0;
        for (LogicCanvasComponent elseComponent : elseComponents) {
            LogicGeneratedCode elseSlot = context.generate(elseComponent, new Object[]{LogicGenerateContextualHintFeature.STATEMENT});
            elseSlots.put("else_" + elseIndex++, elseSlot);
        }
        return context.beginTemplate(TEMPLATE_PATH).parameter("ifSlots", ifSlots.keySet()).parameter("hasElse", (Object)MapUtils.isNotEmpty(elseSlots)).parameter("elseSlots", elseSlots.keySet()).slot("condition", conditionSlot).slots(ifSlots).slots(elseSlots).render();
    }
}

