/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.function;

import com.jxdinfo.hussar.logic.component.backend.function.dto.LogicBackendFunctionBindingDto;
import com.jxdinfo.hussar.logic.component.backend.function.dto.LogicBackendFunctionPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendCodePostprocessUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendLiteralUtils;
import com.jxdinfo.hussar.logic.generator.utils.BackendReflectUtils;
import com.jxdinfo.hussar.logic.generator.utils.LogicTypeCheckUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.properties.HussarLogicProperties;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.check.TypeConstraint;
import com.jxdinfo.hussar.logic.structure.reflect.FunctionDescriptor;
import com.jxdinfo.hussar.logic.structure.reflect.GenericVariableDescriptor;
import com.jxdinfo.hussar.logic.structure.reflect.ParameterDescriptor;
import com.jxdinfo.hussar.logic.structure.type.LogicBackendType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicExpressionPropsDto;
import com.jxdinfo.hussar.logic.utils.LogicFunctionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.function.logicBackendFunctionVisitor", component="com.jxdinfo.logic.BackendFunction", taints={"language:java"})
public class LogicBackendFunctionVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendFunctionPropsDto> {
    private static final Logger logger = LoggerFactory.getLogger(LogicBackendFunctionVisitor.class);
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendFunction";
    private static final String TEMPLATE_PATH = "/template/logic/backend/function/function.ftl";
    private static final String TRACE_LOG_EXPLANATION = "%s \u51fd\u6570\u8c03\u7528";
    @Autowired
    private HussarLogicProperties properties;
    private volatile Map<String, FunctionDescriptor> functions = null;

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendFunctionPropsDto> component) {
        LogicType returnsType;
        String function = Optional.ofNullable(component.getProps()).map(LogicBackendFunctionPropsDto::getFunction).orElseThrow(() -> new HussarLogicGenerateVisitorException("extensible function missing function name"));
        Map bindings = Optional.ofNullable(component.getProps()).map(LogicBackendFunctionPropsDto::getBindings).orElseGet(Collections::emptyMap);
        Map values = Optional.ofNullable(component.getProps()).map(LogicBackendFunctionPropsDto::getValues).orElseGet(Collections::emptyMap);
        LogicType type = Optional.ofNullable(component.getProps()).map(BaseLogicExpressionPropsDto::getType).orElse(null);
        FunctionDescriptor functionDescriptor = this.getFunctions().get(function);
        if (functionDescriptor == null) {
            throw new HussarLogicGenerateVisitorException("extensible function descriptor for '" + function + "' is not found");
        }
        List<ArgumentBinding> argumentBindings = this.calculateArgumentBindings(component, functionDescriptor, bindings, values);
        LinkedHashMap<String, LogicGeneratedCode> argumentSlots = new LinkedHashMap<String, LogicGeneratedCode>();
        for (ArgumentBinding argumentBinding : argumentBindings) {
            if (argumentBinding.isSlot()) {
                LogicCanvasComponent argumentComponent = argumentBinding.getSlotComponent();
                LogicGeneratedCode argumentSlot = context.generate(argumentComponent, new Object[]{LogicGenerateContextualHintFeature.EXPRESSION});
                argumentBinding.setSlotCode(argumentSlot);
                argumentSlots.put(argumentBinding.getSlotName(), argumentSlot);
                continue;
            }
            Iterator<ArgumentBinding> propValue = argumentBinding.getPropValue();
            LogicType propType = argumentBinding.getPropType();
            if (!(propValue instanceof String)) {
                throw new HussarLogicGenerateVisitorException("prop binding of non-string value");
            }
            String propLiteral = BackendLiteralUtils.literalOf((BackendLogicGenerateContext)context, (LogicBackendType)context.addType(propType), (String)((String)((Object)propValue)));
            argumentBinding.setPropLiteral(propLiteral);
        }
        boolean typeComplete = true;
        ArrayList<LogicType> argumentTypes = new ArrayList<LogicType>(argumentBindings.size());
        for (ArgumentBinding argumentBinding : argumentBindings) {
            LogicType argumentType = argumentBinding.isSlot() ? (LogicType)Optional.ofNullable(argumentBinding.getSlotCode()).map(LogicGeneratedCode::getType).orElse(null) : argumentBinding.getPropType();
            if (argumentType == null) {
                typeComplete = false;
                String argumentName = argumentBinding.getName();
                logger.warn("argument '{}' of extensible function '{}' missing type info", (Object)argumentName, (Object)function);
            }
            argumentTypes.add(argumentType);
        }
        LogicType logicType = returnsType = typeComplete ? this.checkAndInferReturnsType(functionDescriptor, argumentTypes, type) : type;
        if (returnsType == null && functionDescriptor.getReturnsType() != null) {
            throw new HussarLogicGenerateVisitorException("extensible function '" + function + "' missing return type and cannot be inferred");
        }
        String utilsClassName = context.addImport(functionDescriptor.getClazz());
        String methodName = functionDescriptor.getMethod();
        String traceExplanation = String.format(TRACE_LOG_EXPLANATION, function);
        return context.beginTemplate(TEMPLATE_PATH).parameter("utilsName", (Object)utilsClassName).parameter("methodName", (Object)methodName).parameter("arguments", argumentBindings).slots(argumentSlots).render().typed(returnsType).postprocess(BackendCodePostprocessUtils.assignOrInvokeIfStatementContextual((BackendLogicGenerateContext)context, component, (LogicType)returnsType, (String)traceExplanation));
    }

    private List<ArgumentBinding> calculateArgumentBindings(LogicGenerateComponent<LogicBackendFunctionPropsDto> component, FunctionDescriptor functionDescriptor, Map<String, LogicBackendFunctionBindingDto> bindings, Map<String, Object> values) {
        LinkedHashMap<String, ParameterDescriptor> parameters = new LinkedHashMap<String, ParameterDescriptor>();
        for (ParameterDescriptor parameterDescriptor : functionDescriptor.getParameters()) {
            parameters.put(parameterDescriptor.getName(), parameterDescriptor);
        }
        ArgumentBinding[] arguments = new ArgumentBinding[parameters.size()];
        for (Map.Entry<String, LogicBackendFunctionBindingDto> bindingEntry : bindings.entrySet()) {
            String parameterName = bindingEntry.getKey();
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameters.get(parameterName);
            if (parameterDescriptor == null) {
                logger.warn("redundant argument '{}' for extensible function '{}'", (Object)parameterName, (Object)functionDescriptor.getName());
                continue;
            }
            int order = parameterDescriptor.getOrder();
            if (arguments[order] != null) {
                throw new HussarLogicGenerateVisitorException("conflicted parameter order " + order + " of argument " + parameterName + " and " + arguments[order].getName() + " for extensible function '" + functionDescriptor.getName() + "'");
            }
            ArgumentBinding argument = new ArgumentBinding();
            argument.setOrder(order);
            argument.setName(parameterName);
            String bingingKind = bindingEntry.getValue().getKind();
            String bindingRefer = bindingEntry.getValue().getRefer();
            if ("SLOT".equals(bingingKind)) {
                argument.setSlot(true);
                LogicCanvasComponent slotComponent = component.getSingletonSlot(bindingRefer);
                if (slotComponent == null) {
                    logger.warn("missing binding component for parameter '{}' of extensible function '{}'", (Object)parameterName, (Object)functionDescriptor.getName());
                    continue;
                }
                argument.setSlotName("slot_" + parameterName);
                argument.setSlotComponent(slotComponent);
            } else if ("PROP".equals(bingingKind)) {
                argument.setSlot(false);
                Object propValue = values.get(bindingRefer);
                LogicType propType = bindingEntry.getValue().getType();
                if (propValue == null || propType == null) {
                    logger.warn("missing binding prop value/type for parameter '{}' of extensible function '{}'", (Object)parameterName, (Object)functionDescriptor.getName());
                    continue;
                }
                argument.setPropValue(propValue);
                argument.setPropType(propType);
            } else {
                logger.warn("unsupported binding kind '{}' for parameter '{}' of extensible function '{}'", new Object[]{bingingKind, parameterName, functionDescriptor.getName()});
                continue;
            }
            arguments[order] = argument;
        }
        for (ParameterDescriptor parameterDescriptor : parameters.values()) {
            int order = parameterDescriptor.getOrder();
            if (order >= 0 && order <= arguments.length && arguments[order] != null) continue;
            throw new HussarLogicGenerateVisitorException("parameter '" + parameterDescriptor.getName() + "' is missing for extensible function '" + functionDescriptor.getName() + "'");
        }
        if (Arrays.stream(arguments).anyMatch(Objects::isNull)) {
            throw new HussarLogicGenerateVisitorException("missing argument binding for extensible function '" + functionDescriptor.getName() + "'");
        }
        return new ArrayList<ArgumentBinding>(Arrays.asList(arguments));
    }

    private LogicType checkAndInferReturnsType(FunctionDescriptor functionDescriptor, List<LogicType> argumentTypes, LogicType returnsType) {
        LogicType logicType;
        List parameters = functionDescriptor.getParameters();
        if (parameters.size() != argumentTypes.size()) {
            logger.warn("parameters and arguments count mismatched for extensible function '{}'", (Object)functionDescriptor.getName());
            return returnsType;
        }
        LinkedHashMap<String, LogicType> reifications = new LinkedHashMap<String, LogicType>();
        for (int i = 0; i < parameters.size(); ++i) {
            ParameterDescriptor parameter = (ParameterDescriptor)parameters.get(i);
            LogicType logicType2 = argumentTypes.get(i);
            Map matched = LogicTypeCheckUtils.match((LogicType)parameter.getType(), (LogicType)logicType2);
            if (matched == null) {
                logger.error("argument type '{}' mismatched parameter '{}' of extensible function '{}'", new Object[]{logicType2, parameter, functionDescriptor.getName()});
                return returnsType;
            }
            for (Map.Entry matchEntry : matched.entrySet()) {
                LogicType concreteType;
                String variableName = (String)matchEntry.getKey();
                LogicType previousType = reifications.putIfAbsent(variableName, concreteType = (LogicType)matchEntry.getValue());
                if (previousType == null || LogicTypeCheckUtils.isSame((LogicType)concreteType, (LogicType)previousType)) continue;
                logger.error("generic variable '{}' of extensible function '{}' inconsistent: {} != {}", new Object[]{variableName, functionDescriptor.getName(), concreteType, previousType});
                return returnsType;
            }
        }
        LinkedHashMap<String, List> genericConstraints = new LinkedHashMap<String, List>();
        for (GenericVariableDescriptor genericVariableDescriptor : functionDescriptor.getGenerics()) {
            genericConstraints.put(genericVariableDescriptor.getName(), genericVariableDescriptor.getConstraints());
        }
        for (Map.Entry entry : reifications.entrySet()) {
            String variableName = (String)entry.getKey();
            LogicType concreteType = (LogicType)entry.getValue();
            List constraints = Optional.ofNullable(genericConstraints.get(variableName)).orElse(Collections.emptyList());
            for (TypeConstraint constraint : constraints) {
                Boolean ok = constraint.check(concreteType);
                if (ok == null) {
                    logger.debug("constraint '{}' of generic variable '{}' of extensible function '{}' is uncertain for: {}", new Object[]{constraint, variableName, functionDescriptor.getName(), concreteType});
                    continue;
                }
                if (ok.booleanValue()) continue;
                logger.error("constraint '{}' of generic variable '{}' of extensible function '{}' cannot be satisfied by: {}", new Object[]{constraint, variableName, functionDescriptor.getName(), concreteType});
                return returnsType;
            }
        }
        LogicType genericReturnsType = functionDescriptor.getReturnsType();
        if (genericReturnsType == null) {
            return null;
        }
        try {
            logicType = LogicTypeCheckUtils.specialize((LogicType)genericReturnsType, reifications);
        }
        catch (Exception ex) {
            logger.error("extensible function '{}' returns type cannot be specialized: {}, known generic variables: {}", new Object[]{functionDescriptor.getName(), genericReturnsType, reifications, ex});
            return returnsType;
        }
        if (returnsType != null && !LogicTypeCheckUtils.isSame((LogicType)returnsType, (LogicType)logicType)) {
            logger.error("extensible function '{}' returns type mismatched: {} <=> {}", new Object[]{functionDescriptor.getName(), returnsType, logicType});
            return logicType;
        }
        return logicType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FunctionDescriptor> getFunctions() {
        if (this.functions == null) {
            LogicBackendFunctionVisitor logicBackendFunctionVisitor = this;
            synchronized (logicBackendFunctionVisitor) {
                if (this.functions == null) {
                    ArrayList functionMethods = new ArrayList();
                    for (Class<?> clazz : this.getUtilsClasses()) {
                        try {
                            functionMethods.addAll(BackendReflectUtils.loadExportedMethods(clazz));
                        }
                        catch (Exception ex) {
                            logger.error("cannot load extensible function descriptors from class {}", clazz, (Object)ex);
                        }
                    }
                    ArrayList<FunctionDescriptor> functionDescriptors = new ArrayList<FunctionDescriptor>();
                    for (Method functionMethod : functionMethods) {
                        try {
                            functionDescriptors.add(BackendReflectUtils.loadFunction((Method)functionMethod));
                        }
                        catch (Exception ex) {
                            logger.error("cannot load extensible function descriptor from method {}::{}", new Object[]{functionMethod.getDeclaringClass().getName(), functionMethod.getName(), ex});
                        }
                    }
                    LinkedHashMap<String, FunctionDescriptor> linkedHashMap = new LinkedHashMap<String, FunctionDescriptor>();
                    for (FunctionDescriptor descriptor : functionDescriptors) {
                        FunctionDescriptor previousDescriptor = linkedHashMap.put(descriptor.getName(), descriptor);
                        if (previousDescriptor == null) continue;
                        logger.warn("override extensible function descriptor: " + previousDescriptor + " ==> " + descriptor);
                    }
                    this.functions = linkedHashMap;
                }
            }
        }
        return Optional.ofNullable(this.functions).orElse(Collections.emptyMap());
    }

    private Set<Class<?>> getUtilsClasses() {
        LinkedHashSet utilsClasses = new LinkedHashSet();
        utilsClasses.add(LogicFunctionUtils.class);
        for (String additionalUtils : Optional.ofNullable(this.properties.getAdditionalFunctionUtils()).orElse(Collections.emptyList())) {
            try {
                Class<?> additionalClass = Class.forName(additionalUtils);
                utilsClasses.add(additionalClass);
            }
            catch (Exception ex) {
                logger.warn("additional extensible function utils class not found: {}", (Object)additionalUtils, (Object)ex);
            }
        }
        return utilsClasses;
    }

    public static final class ArgumentBinding {
        private boolean slot;
        private int order;
        private String name;
        private String slotName;
        private LogicCanvasComponent slotComponent;
        private LogicGeneratedCode slotCode;
        private LogicType propType;
        private Object propValue;
        private String propLiteral;

        public boolean isSlot() {
            return this.slot;
        }

        public void setSlot(boolean slot) {
            this.slot = slot;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSlotName() {
            return this.slotName;
        }

        public void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        public LogicCanvasComponent getSlotComponent() {
            return this.slotComponent;
        }

        public void setSlotComponent(LogicCanvasComponent slotComponent) {
            this.slotComponent = slotComponent;
        }

        public LogicGeneratedCode getSlotCode() {
            return this.slotCode;
        }

        public void setSlotCode(LogicGeneratedCode slotCode) {
            this.slotCode = slotCode;
        }

        public LogicType getPropType() {
            return this.propType;
        }

        public void setPropType(LogicType propType) {
            this.propType = propType;
        }

        public Object getPropValue() {
            return this.propValue;
        }

        public void setPropValue(Object propValue) {
            this.propValue = propValue;
        }

        public String getPropLiteral() {
            return this.propLiteral;
        }

        public void setPropLiteral(String propLiteral) {
            this.propLiteral = propLiteral;
        }
    }
}

