/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.foreach;

import com.jxdinfo.hussar.logic.component.backend.foreach.dto.LogicBackendForEachPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendVariableDefinition;
import com.jxdinfo.hussar.logic.structure.definition.LogicVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.config.LogicGenerationRuntime;
import com.jxdinfo.hussar.logic.structure.type.LogicBuiltinType;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.utils.LogicSupportUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.foreach.logicBackendForEachVisitor", component="com.jxdinfo.logic.BackendForEach", taints={"language:java"})
public class LogicBackendForEachVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendForEachPropsDto> {
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendForEach";
    private static final String TEMPLATE_PATH = "/template/logic/backend/foreach/foreach.ftl";
    private static final String SLOT_EXPRESSION = "loopExpression";
    private static final String SLOT_BODY = "loopBody";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendForEachPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.STATEMENT)) {
            throw new HussarLogicGenerateVisitorException("for each is incompatible with non-statement context");
        }
        String item = Optional.ofNullable(component.getProps()).map(LogicBackendForEachPropsDto::getItem).filter(StringUtils::isNotBlank).orElseThrow(() -> new HussarLogicGenerateVisitorException("foreach missing item variable name"));
        LogicCanvasComponent expressionComponent = Optional.ofNullable(component.getSingletonSlot(SLOT_EXPRESSION)).orElseThrow(() -> new HussarLogicGenerateVisitorException("foreach missing loop container expression"));
        List bodyComponents = Optional.ofNullable(component.getSlot(SLOT_BODY)).orElseGet(Collections::emptyList);
        LogicGeneratedCode expressionSlot = context.generate(expressionComponent, new Object[]{LogicGenerateContextualHintFeature.EXPRESSION});
        LogicType containerType = Optional.ofNullable(expressionSlot.getType()).orElseThrow(() -> new HussarLogicGenerateVisitorException("foreach loop container expression missing type"));
        if (!containerType.isBuiltin() || containerType.getBuiltinTypeName() != LogicBuiltinType.LIST || containerType.getArgumentCount() != 1) {
            throw new HussarLogicGenerateVisitorException("foreach loop container expression returns non-list type");
        }
        LogicType itemType = (LogicType)containerType.getTypeArguments().get(0);
        LinkedHashMap<String, LogicGeneratedCode> bodySlots = new LinkedHashMap<String, LogicGeneratedCode>();
        if (context.getConfigure().getRuntime() == LogicGenerationRuntime.ENGINE) {
            bodySlots.put("body_checkpoint", context.getCodeFragment(context.addImport(LogicSupportUtils.class.getName()) + ".checkpoint();"));
        }
        LogicBackendVariableDefinition itemVariable = (LogicBackendVariableDefinition)context.withLocalScope(() -> {
            LogicBackendVariableDefinition itemVariableDefinition = context.addVariable(LogicVariableDefinition.of((String)item, (LogicType)itemType));
            int i = 0;
            for (LogicCanvasComponent bodyComponent : bodyComponents) {
                LogicGeneratedCode bodySlot = context.generate(bodyComponent, new Object[]{LogicGenerateContextualHintFeature.STATEMENT});
                bodySlots.put("body_" + i++, bodySlot);
            }
            return itemVariableDefinition;
        });
        return context.beginTemplate(TEMPLATE_PATH).parameter("item", (Object)itemVariable).parameter("bodySlots", bodySlots.keySet()).slot("expression", expressionSlot).slots(bodySlots).render();
    }
}

