/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.expression;

import com.jxdinfo.hussar.logic.component.backend.expression.dto.LogicBackendExpressionPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendTypeReferenceUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicExpressionPropsDto;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.ir.visitor.SimpleNodeVisitor;
import jdk.nashorn.internal.parser.Parser;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.options.Options;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogicBackendExpressionVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendExpressionPropsDto> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLogicBackendExpressionVisitor.class);
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendExpression";
    private static final String INLINE_TEMPLATE_PATH = "/template/logic/backend/expression/inline.ftl";
    private static final String LANGUAGE_JS = "javascript";
    private static final String LANGUAGE_JAVA = "java";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendExpressionPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.EXPRESSION)) {
            throw new HussarLogicGenerateVisitorException("expression is incompatible with non-expression context");
        }
        String language = Optional.ofNullable(component.getProps()).map(LogicBackendExpressionPropsDto::getLanguage).filter(StringUtils::isNotEmpty).orElse(LANGUAGE_JS);
        String expression = Optional.ofNullable(component.getProps()).map(LogicBackendExpressionPropsDto::getExpression).filter(StringUtils::isNotBlank).orElseThrow(() -> new HussarLogicGenerateVisitorException("script missing props: expression"));
        LogicType type = Optional.ofNullable(component.getProps()).map(BaseLogicExpressionPropsDto::getType).orElse(null);
        switch (language) {
            case "java": {
                return this.generateJavaExpression(context, expression, type);
            }
            case "javascript": {
                return this.generateJsExpression(context, expression, type);
            }
        }
        throw new HussarLogicGenerateVisitorException("unsupported language for expression: " + language);
    }

    protected LogicGeneratedCode generateJavaExpression(BackendLogicGenerateContext context, String expression, LogicType type) {
        return context.beginTemplate(INLINE_TEMPLATE_PATH).parameter("expression", (Object)expression).render().typed(type);
    }

    protected LogicGeneratedCode generateJsExpression(BackendLogicGenerateContext context, String expression, LogicType type) {
        Set<String> varBindings = this.getJsBindings(expression, context.getVariableNames());
        boolean hasResultType = false;
        LogicGeneratedCode resultType = null;
        if (type != null) {
            hasResultType = true;
            resultType = BackendTypeReferenceUtils.renderTypeReference((BackendLogicGenerateContext)context, (LogicType)type);
        }
        return this.generateJsExpression(context, varBindings, expression, hasResultType, resultType, type);
    }

    protected abstract LogicGeneratedCode generateJsExpression(BackendLogicGenerateContext var1, Set<String> var2, String var3, boolean var4, LogicGeneratedCode var5, LogicType var6);

    protected Set<String> getDefaultBindings(String expression, Set<String> available) {
        LinkedHashSet<String> occurrences = new LinkedHashSet<String>();
        for (String name : available) {
            if (!expression.contains(name)) continue;
            occurrences.add(name);
        }
        return occurrences;
    }

    protected Set<String> getJsBindings(String expression, Set<String> available) {
        try {
            Options options = new Options("nashorn");
            options.set("anon.functions", true);
            options.set("parse.only", true);
            options.set("scripting", true);
            StringWriter errorMessage = new StringWriter();
            ErrorManager errorManager = new ErrorManager(new PrintWriter(errorMessage));
            Context context = new Context(options, errorManager, Thread.currentThread().getContextClassLoader());
            Source source = Source.sourceFor((String)"expression", (String)expression);
            Parser parser = new Parser(context.getEnv(), source, errorManager);
            FunctionNode node = parser.parse();
            if (errorManager.hasErrors()) {
                throw new HussarLogicGenerateVisitorException("javascript parser error: " + errorMessage);
            }
            VariableReferenceCollectorVisitor visitor = new VariableReferenceCollectorVisitor();
            node.accept((NodeVisitor)visitor);
            Set<String> references = visitor.getReferences();
            return available.stream().filter(references::contains).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            logger.warn("failed to analyse js bindings", (Throwable)ex);
            return this.getDefaultBindings(expression, available);
        }
    }

    private static final class VariableReferenceCollectorVisitor
    extends SimpleNodeVisitor {
        private final Set<String> references = new LinkedHashSet<String>();

        private VariableReferenceCollectorVisitor() {
        }

        public boolean enterIdentNode(IdentNode identNode) {
            this.references.add(identNode.getName());
            return true;
        }

        public Set<String> getReferences() {
            return this.references;
        }
    }
}

