/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.end;

import com.jxdinfo.hussar.logic.component.backend.end.dto.LogicBackendEndPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendLiteralUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.definition.LogicVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.end.logicBackendEndVisitor", component="com.jxdinfo.logic.BackendEnd", taints={"language:java"})
public class LogicBackendEndVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendEndPropsDto> {
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendEnd";
    private static final String TRACE_LOG_LOGIC_RETURNS_VOID = "<== \u903b\u8f91 %s (%s) \u7ed3\u675f";
    private static final String TRACE_LOG_LOGIC_RETURNS_VALUE = "<== \u903b\u8f91 %s (%s) \u7ed3\u675f, \u8fd4\u56de {}";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendEndPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.STATEMENT)) {
            throw new HussarLogicGenerateVisitorException("end is incompatible with non-statement context");
        }
        boolean topLevel = Optional.ofNullable(component.getProps()).map(LogicBackendEndPropsDto::getTopLevel).orElse(false);
        String resultName = Optional.ofNullable(context.getMetadata().getResult()).map(LogicVariableDefinition::getName).orElse(null);
        String traceLogging = this.generateTraceLog(context, resultName);
        if (resultName != null) {
            return context.getCodeFragment(traceLogging + "return " + resultName + ";");
        }
        if (!topLevel) {
            return context.getCodeFragment(traceLogging + "return;");
        }
        return context.getCodeFragment(traceLogging);
    }

    private String generateTraceLog(BackendLogicGenerateContext context, String resultName) {
        boolean allowTraceLog = Optional.ofNullable(context.getConfigure()).map(LogicGenerateConfigure::getAllowTraceLogging).orElse(false);
        if (!allowTraceLog) {
            return "";
        }
        String traceLogger = (String)context.getAttribute("logger.symbol", String.class);
        String traceMessage = String.format(resultName != null ? TRACE_LOG_LOGIC_RETURNS_VALUE : TRACE_LOG_LOGIC_RETURNS_VOID, context.getMetadata().getTitle(), context.getMetadata().getName());
        if (StringUtils.isEmpty((CharSequence)traceLogger) || StringUtils.isEmpty((CharSequence)traceMessage)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(traceLogger).append(".trace(").append(BackendLiteralUtils.stringLiteralOf((BackendLogicGenerateContext)context, (String)traceMessage));
        if (resultName != null) {
            builder.append(", ").append(resultName);
        }
        builder.append(");\n");
        return builder.toString();
    }
}

