/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.assign;

import com.jxdinfo.hussar.logic.component.backend.assign.dto.LogicBackendAssignPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendVariableAccessUtils;
import com.jxdinfo.hussar.logic.generator.utils.LogicTypeCheckUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.definition.LogicBackendVariableDefinition;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.assign.logicBackendAssignVisitor", component="com.jxdinfo.logic.BackendAssign", taints={"language:java"})
public class LogicBackendAssignVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendAssignPropsDto> {
    private static final Logger logger = LoggerFactory.getLogger(LogicBackendAssignVisitor.class);
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendAssign";

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendAssignPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.STATEMENT)) {
            throw new HussarLogicGenerateVisitorException("assign is incompatible with non-statement context");
        }
        List left = Optional.ofNullable(component.getProps()).map(LogicBackendAssignPropsDto::getVariable).filter(CollectionUtils::isNotEmpty).orElseThrow(() -> new HussarLogicGenerateVisitorException("assign missing variable"));
        LogicCanvasComponent right = Optional.ofNullable(component.getSingletonSlot("default")).orElseThrow(() -> new HussarLogicGenerateVisitorException("assign missing value"));
        LogicGeneratedCode value = context.generate(right, new Object[]{LogicGenerateContextualHintFeature.EXPRESSION});
        String name = (String)left.get(0);
        LogicBackendVariableDefinition variable = context.getVariable(name);
        if (variable == null) {
            logger.warn("no such variable: {}", (Object)name);
        }
        if (value.getType() != null && variable != null && variable.getOriginalType() != null && !LogicTypeCheckUtils.isAssignableFrom((LogicType)variable.getOriginalType(), (LogicType)value.getType())) {
            logger.warn("assign type mismatch: {} (variable: {}) <== {}", new Object[]{variable.getOriginalType(), name, value.getType()});
        }
        boolean allowTraceLog = Optional.ofNullable(context.getConfigure()).map(LogicGenerateConfigure::getAllowTraceLogging).orElse(false);
        return BackendVariableAccessUtils.renderVariableWrite((BackendLogicGenerateContext)context, (List)left, (LogicGeneratedCode)value, (boolean)allowTraceLog);
    }
}

