/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.logic.component.backend.arithmetic;

import com.jxdinfo.hussar.logic.component.backend.arithmetic.dto.LogicBackendArithmeticPropsDto;
import com.jxdinfo.hussar.logic.exception.HussarLogicGenerateVisitorException;
import com.jxdinfo.hussar.logic.generator.annotation.LogicGenerateVisitorService;
import com.jxdinfo.hussar.logic.generator.context.BackendLogicGenerateContext;
import com.jxdinfo.hussar.logic.generator.utils.BackendCodePostprocessUtils;
import com.jxdinfo.hussar.logic.generator.visitor.AbstractBackendLogicGenerateVisitor;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateContextualHintFeature;
import com.jxdinfo.hussar.logic.generator.visitor.feature.LogicGenerateFeature;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.type.LogicType;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGenerateComponent;
import com.jxdinfo.hussar.logic.structure.visitor.LogicGeneratedCode;
import com.jxdinfo.hussar.logic.structure.visitor.props.BaseLogicExpressionPropsDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LogicGenerateVisitorService(value="com.jxdinfo.hussar.logic.component.backend.arithmetic.logicBackendArithmeticVisitor", component="com.jxdinfo.logic.BackendArithmetic", taints={"language:java"})
public class LogicBackendArithmeticVisitor
extends AbstractBackendLogicGenerateVisitor<LogicBackendArithmeticPropsDto> {
    public static final Logger logger = LoggerFactory.getLogger(LogicBackendArithmeticVisitor.class);
    public static final String COMPONENT_NAME = "com.jxdinfo.logic.BackendArithmetic";
    private static final String TEMPLATE_PATH = "/template/logic/backend/arithmetic/arithmetic.ftl";
    private static final Map<String, String> OPERATORS;

    public LogicGeneratedCode generate(BackendLogicGenerateContext context, LogicGenerateComponent<LogicBackendArithmeticPropsDto> component) {
        if (!context.getArguments().satisfy((LogicGenerateFeature)LogicGenerateContextualHintFeature.EXPRESSION)) {
            throw new HussarLogicGenerateVisitorException("arithmetic is incompatible with non-expression context");
        }
        String operator = Optional.ofNullable(component.getProps()).map(LogicBackendArithmeticPropsDto::getOperator).orElseThrow(() -> new HussarLogicGenerateVisitorException("arithmetic missing operator"));
        List operands = Optional.ofNullable(component.getProps()).map(LogicBackendArithmeticPropsDto::getOperands).filter(ops -> CollectionUtils.size((Object)ops) >= 2).orElseThrow(() -> new HussarLogicGenerateVisitorException("arithmetic operands length must be greater or equals to 2"));
        LogicType type = Optional.ofNullable(component.getProps()).map(BaseLogicExpressionPropsDto::getType).orElse(null);
        String symbol = OPERATORS.get(operator);
        if (symbol == null) {
            throw new HussarLogicGenerateVisitorException("illegal arithmetic operator: " + operator);
        }
        ArrayList<LogicCanvasComponent> operandComponents = new ArrayList<LogicCanvasComponent>();
        for (String operand : operands) {
            LogicCanvasComponent operandComponent = component.getSingletonSlot(operand);
            if (operandComponent == null) {
                throw new HussarLogicGenerateVisitorException("arithmetic missing operand slot: " + operand);
            }
            operandComponents.add(operandComponent);
        }
        int i = 0;
        LinkedHashMap<String, LogicGeneratedCode> operandSlots = new LinkedHashMap<String, LogicGeneratedCode>();
        for (LogicCanvasComponent operandComponent : operandComponents) {
            LogicGeneratedCode operandSlot = context.generate(operandComponent, new Object[]{LogicGenerateContextualHintFeature.EXPRESSION}).postprocess(BackendCodePostprocessUtils.automaticParenthesis((BackendLogicGenerateContext)context));
            operandSlots.put("operand_" + i++, operandSlot);
        }
        return context.beginTemplate(TEMPLATE_PATH).parameter("operator", (Object)symbol).parameter("operands", operandSlots.keySet()).slots(operandSlots).render().typed(type);
    }

    static {
        LinkedHashMap<String, String> operators = new LinkedHashMap<String, String>();
        operators.put("+", "+");
        operators.put("-", "-");
        operators.put("*", "*");
        operators.put("/", "/");
        operators.put("%", "%");
        OPERATORS = Collections.unmodifiableMap(operators);
    }
}

