/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.mutidatasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.core.mutidatasource.DynamicDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
public class DataSourceConfig {
    @Autowired
    private MybatisPlusInterceptor paginationInterceptor;

    @Bean(name={"sqlSessionFactory"})
    @DependsOn(value={"coreDataSource"})
    @Primary
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="dataSource") DataSource a) throws Exception {
        MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        Interceptor[] interceptorArray = new Interceptor[1];
        interceptorArray[0] = this.paginationInterceptor;
        Interceptor[] interceptorArray2 = interceptorArray;
        MybatisSqlSessionFactoryBean mybatisSqlSessionFactoryBean2 = mybatisSqlSessionFactoryBean;
        mybatisSqlSessionFactoryBean2.setPlugins(interceptorArray2);
        mybatisSqlSessionFactoryBean2.setDataSource(a);
        mybatisSqlSessionFactoryBean2.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(InstallResult.ALLATORIxDEMO("\u00030\u0001/\u0013,\u0001(\bvZ?\u000f1O6\u00188\t2\u00063O4\u0015/\u0013=\u0012sJvO1\u0001,\u00105\u000e;OvN$\r0")));
        return mybatisSqlSessionFactoryBean.getObject();
    }

    @Bean
    public DataSourceTransactionManager transactionManager(@Qualifier(value="dataSource") DataSource a) {
        return new DataSourceTransactionManager(a);
    }

    public DataSourceConfig() {
        DataSourceConfig a;
    }

    @Bean
    @ConfigurationProperties(value="spring.datasource")
    public DataSource coreDataSource() {
        DruidDataSource druidDataSource;
        DruidDataSource druidDataSource2 = druidDataSource = DruidDataSourceBuilder.create().build();
        druidDataSource2.setConnectionErrorRetryAttempts(3);
        druidDataSource2.setBreakAfterAcquireFailure(true);
        return druidDataSource2;
    }

    @Bean
    @Primary
    public DataSource dataSource() {
        DataSourceConfig a;
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        DataSource dataSource = a.coreDataSource();
        dynamicDataSource.createDataSource("master", (DruidDataSource)dataSource);
        dynamicDataSource.setDefaultTargetDataSource(dataSource);
        return dynamicDataSource;
    }
}

