/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.exception;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.impl.DefinitionEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.exception.TenantLackInfoException;
import com.jxdinfo.hussar.bsp.exception.TenantLockException;
import com.jxdinfo.hussar.bsp.rabbitmq.receiver.ClientListenerReceiver;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0x7FFFFFFD)
public class BpmExceptionHander {
    private static Logger LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    @ExceptionHandler(value={PropertyNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(PropertyNotFoundException a) {
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getPropertyNotFound(), null);
    }

    @ExceptionHandler(value={TenantLackInfoException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLackInfoException a) {
        return ApiResponse.fail(BpmEnum.INCOMPLETE_TENANT_INFORMATION.getCode(), BpmEnum.INCOMPLETE_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("|.Q!P;\u001f<Z;\u001f<J<O*Q<V QoL;^;Zo\u0018<J<O*Q+Z+\u0018oY Moo=P,Z<L\u000bZ)V!V;V Q\nQ;V;F"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("\f^!Q KoL*KoL:L?Z!L&P!\u001f<K.K*\u001fh^,K&I*\u0018oY Moo=P,Z<L\u000bZ)V!V;V Q\nQ;V;F"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("|.Q!P;\u001f<Z;\u001f<J<O*Q<V QoL;^;Zo\u0018<J<O*Q+Z+\u0018oY Moo=P,Z<L\u0006Q<K.Q,Z"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("\f^!Q KoL*KoL:L?Z!L&P!\u001f<K.K*\u001fh^,K&I*\u0018oY Moo=P,Z<L\u0006Q<K.Q,Z"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("\u001fM \\*L<\u001f&Q<K.Q,ZoV<\u001f<K&S#\u001f=J!Q&Q(\u0013o\\.Q!P;\u001f+Z#Z;ZoW&L;P=V,\u001f?M \\*L<\u001f&Q<K.Q,Z"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessInstanceIsNotEnd(), null);
        }
        if (ClientListenerReceiver.ALLATORIxDEMO("|.Q!P;\u001f,S.V\"\u001f.\u001f<J<O*Q+Z+\u001f;^<T").equals(a.getMessage())) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskIsSuspended(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExceptionHandler(value={GodAxeRequestException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(GodAxeRequestException a) {
        switch (a.getRequestErrorType()) {
            case 0: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorProjectAddress(), null);
            }
            case 1: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorGodaxeVisitor(), null);
            }
        }
        return InstallResult.getResult("0", bpmConstantProperties.getErrorGodaxeRequest(), null);
    }

    public BpmExceptionHander() {
        BpmExceptionHander a;
    }

    @ExceptionHandler(value={TenantLockException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLockException a) {
        return ApiResponse.fail(BpmEnum.USER_HAS_BEEN_DISABLED.getCode(), BpmEnum.USER_HAS_BEEN_DISABLED.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiIllegalArgumentException activitiIllegalArgumentException) {
        void a;
        LOGGER.error(a.getMessage());
        if (a.getMessage().contains(ClientListenerReceiver.ALLATORIxDEMO("\u001f!J#S"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiTaskAlreadyClaimedException a) {
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getTaskAlreadyClaimed(), null);
    }

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiObjectNotFoundException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("|.Q!P;\u001f)V![oK.L$\u001f8V;WoV+\u001f"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskNotFound(), null);
        }
        if (a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("\f^!Q KoY&Q+\u001f?M \\*L<\u001f+Z)V!V;V QoY MoV+\u001f")) || a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("!Po[*O#P6Z+\u001f?M \\*L<\u001f+Z)V!V;V QoY J![oH&K'\u001f&["))) {
            return InstallResult.getResult("0", bpmConstantProperties.getModelNotFound(), null);
        }
        if (a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("\f^!Q KoY&Q+\u001f?M \\*L<v!L;^!\\*\u001f)P=\u001f&[")) || a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("\u0001PoO=P,Z<LoV!L;^!\\*\u001f)P:Q+\u001f)P=\u001f&[")) || a.getMessage().startsWith(ClientListenerReceiver.ALLATORIxDEMO("\u0001PoW&L;P=V,\u001f?M \\*L<\u001f&Q<K.Q,ZoY J![oH&K'\u001f&["))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessNotFound(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    @ExceptionHandler(value={TenantException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantException a) {
        return ApiResponse.fail(BpmEnum.ERROR_TENANT_INFORMATION.getCode(), BpmEnum.ERROR_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(HttpServletRequest a, PublicClientException a2) {
        if (a2.getIsSaveLogger().booleanValue()) {
            Serializable serializable = a2.getStackTrace()[0];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(a2.getReason());
            stringBuilder.append(ClientListenerReceiver.ALLATORIxDEMO("\u5f3d\u5e77\u7c44\u5442\uff25")).append(((StackTraceElement)serializable).getClassName());
            stringBuilder.append(ClientListenerReceiver.ALLATORIxDEMO("\u5f4d\u5e07\u65f6\u6cea\u5442\uff25")).append(((StackTraceElement)serializable).getMethodName());
            stringBuilder.append(ClientListenerReceiver.ALLATORIxDEMO("\u0004\u5f4d\u5e07\u65c8\u4ec9\u5442\uff25")).append(((StackTraceElement)serializable).getFileName());
            stringBuilder.append(ClientListenerReceiver.ALLATORIxDEMO("\u5f3d\u5e77\u8873\u653f\uff25")).append(((StackTraceElement)serializable).getLineNumber());
            stringBuilder.append(ClientListenerReceiver.ALLATORIxDEMO("\u8bc8\u6c0d\u8dd0\u5fcb\uff25")).append(a.getRequestURL()).append(ClientListenerReceiver.ALLATORIxDEMO("\u0004"));
            serializable = new HashMap(a.getParameterMap());
            serializable.remove(ClientListenerReceiver.ALLATORIxDEMO(";Z!^!K\fV?W*M"));
            Object object = serializable.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                String[] stringArray = (String[])entry.getValue();
                if (stringArray.length == 0) {
                    serializable.put(entry.getKey(), null);
                    continue;
                }
                if (stringArray.length != 1) continue;
                serializable.put(entry.getKey(), stringArray[0]);
            }
            if (ToolUtil.isNotEmpty((Object)serializable)) {
                stringBuilder.append(ClientListenerReceiver.ALLATORIxDEMO("\u8bc8\u6c0d\u53fd\u653f\uff25")).append(JSONObject.toJSONString((Object)serializable)).append(ClientListenerReceiver.ALLATORIxDEMO("\u0004"));
            }
            object = new HashMap<String, String>();
            object.put("userId", HttpKit.getIp());
            object.put("userAccount", HttpKit.getIp());
            object.put(ClientListenerReceiver.ALLATORIxDEMO("&O"), HttpKit.getIp());
            object.put(ClientListenerReceiver.ALLATORIxDEMO("?P=K"), HttpKit.getPort());
            object.put(ClientListenerReceiver.ALLATORIxDEMO("'P<K"), HttpKit.getHost());
            object.put(ClientListenerReceiver.ALLATORIxDEMO("S \\.S\u0006O"), HttpKit.getLocalIp());
            object.put(ClientListenerReceiver.ALLATORIxDEMO("S \\.S\u001fP=K"), HttpKit.getLocalPort());
            object.put(ClientListenerReceiver.ALLATORIxDEMO("S \\.S\u0007P<K"), HttpKit.getLocalHost());
            object.put(ClientListenerReceiver.ALLATORIxDEMO("L*L<V Q\u0006["), HttpKit.getSeesionId());
            object.put("tenantId", a.getParameter("tenantId"));
            object.put(ClientListenerReceiver.ALLATORIxDEMO(";Z!^!K\fV?W*M"), a.getParameter(ClientListenerReceiver.ALLATORIxDEMO(";Z!^!K\fV?W*M")));
            InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.exceptionLog((Map<String, String>)object, stringBuilder.toString()));
            LOGGER.error(stringBuilder.toString());
            a2.printStackTrace();
        }
        return InstallResult.getResult("0", a2.getReason(), a2.getResult());
    }
}

