/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.flowevents.controller;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowEvents"})
public class FlowEventsController {
    @Autowired
    FlowEventsService flowEventsService;

    @RequestMapping(value={"/todoList"})
    public BpmResponseResult todoList(@RequestParam(required=false) String processDefinitionKey, @RequestParam(required=false) String message, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime, @RequestParam(required=false) String userId, @RequestParam(required=false) String startUserId, @RequestParam(required=false) String tenantId, @RequestParam(required=false) String category, @RequestParam(required=false) String taskDefKey, @RequestParam(required=false, defaultValue="") String type, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="10") Integer limit, @RequestParam(required=false) String bakOne, @RequestParam(required=false) String bakTwo, @RequestParam(required=false) String bakThree, @RequestParam(required=false) String bakFour, @RequestParam(required=false) String bakFive, @RequestParam(required=false) String bakSix) {
        return this.flowEventsService.todoList(userId, processDefinitionKey, message, startUserId, startTime, endTime, page, limit, type, tenantId, category, taskDefKey, bakOne, bakTwo, bakThree, bakFour, bakFive, bakSix);
    }

    @RequestMapping(value={"/doneList"})
    public BpmResponseResult doneList(@RequestParam(required=false) String processDefinitionKey, @RequestParam(required=false) String message, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime, @RequestParam(required=false) String userId, @RequestParam(required=false) String startUserId, @RequestParam(required=false) String tenantId, @RequestParam(required=false) String category, @RequestParam(required=false) String taskDefKey, @RequestParam(required=false) String doneStartTime, @RequestParam(required=false) String doneEndTime, @RequestParam(required=false, defaultValue="") String type, @RequestParam(required=false, defaultValue="1") Integer page, @RequestParam(required=false, defaultValue="10") Integer limit, @RequestParam(required=false) String bakOne, @RequestParam(required=false) String bakTwo, @RequestParam(required=false) String bakThree, @RequestParam(required=false) String bakFour, @RequestParam(required=false) String bakFive, @RequestParam(required=false) String bakSix) {
        return this.flowEventsService.doneList(userId, processDefinitionKey, message, startUserId, startTime, endTime, page, limit, type, tenantId, category, taskDefKey, doneStartTime, doneEndTime, bakOne, bakTwo, bakThree, bakFour, bakFive, bakSix);
    }

    @RequestMapping(value={"/flowType"})
    public BpmResponseResult flowType(String category) {
        List<Map<String, String>> readProcessNameList;
        List<Map<String, String>> definitions = this.flowEventsService.flowType(category);
        JSONArray jsonArray = new JSONArray();
        if (definitions != null) {
            for (Map<String, String> tmp : definitions) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", tmp.get("id"));
                tmpMap.put("name", tmp.get("name"));
                jsonArray.add(tmpMap);
            }
        }
        if ((readProcessNameList = this.flowEventsService.readProcessName()) != null) {
            HashSet<String> ids = new HashSet<String>();
            for (Map<String, String> readProcessName : readProcessNameList) {
                ids.add(readProcessName.get("id"));
            }
            for (String id : ids) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", id);
                tmpMap.put("name", id);
                jsonArray.add(tmpMap);
            }
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @RequestMapping(value={"/getProcNodeName"})
    public BpmResponseResult getProcNodeName(String processDefinitionKey) {
        JSONArray jsonArray = this.flowEventsService.getProcNodeName(processDefinitionKey);
        if (ToolUtil.isEmpty((Object)jsonArray)) {
            jsonArray = new JSONArray();
            List<Map<String, String>> readNodeNameList = this.flowEventsService.getReadNodeName(processDefinitionKey);
            if (ToolUtil.isNotEmpty(readNodeNameList)) {
                HashSet<String> ids = new HashSet<String>();
                for (Map<String, String> readNodeName : readNodeNameList) {
                    ids.add(readNodeName.get("id"));
                }
                for (String id : ids) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    tmpMap.put("id", id);
                    tmpMap.put("name", id);
                    jsonArray.add(tmpMap);
                }
            }
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @RequestMapping(value={"/revokeTask"})
    public BpmResponseResult revokeTask(String historicTaskId, String userId) {
        return this.flowEventsService.revokeTask(historicTaskId, userId);
    }

    @RequestMapping(value={"/urgeTask"})
    public BpmResponseResult urgeTask(String processInsId, String userId) {
        return this.flowEventsService.urgeTask(processInsId, userId);
    }
}

