/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.mutidatasource.interceptor;

import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.exception.TenantLackInfoException;
import com.jxdinfo.hussar.bsp.exception.TenantLockException;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.mutidatasource.util.ChangeDatasource;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TenantDataSourceInterceptor
implements HandlerInterceptor {
    ISysUserService iSysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String tenantId = request.getParameter("tenantId");
        String tenantCipher = request.getParameter("tenantCipher");
        if (ToolUtil.isOneEmpty((Object[])new Object[]{tenantId, tenantCipher})) {
            throw new TenantLackInfoException();
        }
        SysUser sysUser = this.iSysUserService.queryTenantByTenantId(tenantId, tenantCipher);
        if (sysUser == null) {
            throw new TenantException();
        }
        if ("0".equals(sysUser.getState())) {
            throw new TenantLockException();
        }
        ChangeDatasource changeDatasource = new ChangeDatasource();
        changeDatasource.change(sysUser);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) {
    }
}

