/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.mutidatasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.jxdinfo.hussar.core.mutidatasource.DataSourceContextHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private Map<Object, Object> dynamicTargetDataSources = new HashMap<Object, Object>();
    private Object dynamicDefaultTargetDataSource;

    public DynamicDataSource() {
        super.setTargetDataSources(this.dynamicTargetDataSources);
    }

    protected Object determineCurrentLookupKey() {
        return DataSourceContextHolder.getDataSource();
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        super.setTargetDataSources(targetDataSources);
        this.dynamicTargetDataSources = targetDataSources;
    }

    public boolean createDataSource(String key, DruidDataSource druidDataSource) {
        try {
            druidDataSource.setName(key);
            druidDataSource.init();
            druidDataSource.setConnectionErrorRetryAttempts(3);
            druidDataSource.setBreakAfterAcquireFailure(true);
            Map<Object, Object> dynamicTargetDataSources2 = this.dynamicTargetDataSources;
            dynamicTargetDataSources2.put(key, druidDataSource);
            this.setTargetDataSources(dynamicTargetDataSources2);
            super.afterPropertiesSet();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean delDatasources(String datasourceid) {
        Map<Object, Object> dynamicTargetDataSources2 = this.dynamicTargetDataSources;
        if (dynamicTargetDataSources2.containsKey(datasourceid)) {
            Set druidDataSourceInstances = DruidDataSourceStatManager.getDruidDataSourceInstances();
            for (DruidDataSource l : druidDataSourceInstances) {
                if (!datasourceid.equals(l.getName())) continue;
                dynamicTargetDataSources2.remove(datasourceid);
                DruidDataSourceStatManager.removeDataSource((Object)l);
                this.setTargetDataSources(dynamicTargetDataSources2);
                super.afterPropertiesSet();
                return true;
            }
            return false;
        }
        return false;
    }

    public Map<Object, Object> getDynamicTargetDataSources() {
        return this.dynamicTargetDataSources;
    }

    public void setDynamicTargetDataSources(Map<Object, Object> dynamicTargetDataSources) {
        this.dynamicTargetDataSources = dynamicTargetDataSources;
    }

    public Object getDynamicDefaultTargetDataSource() {
        return this.dynamicDefaultTargetDataSource;
    }

    public void setDynamicDefaultTargetDataSource(Object dynamicDefaultTargetDataSource) {
        this.dynamicDefaultTargetDataSource = dynamicDefaultTargetDataSource;
    }
}

