/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.tenant.service.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.tenant.dao.SysUserMapper;
import com.jxdinfo.hussar.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.core.mutidatasource.DynamicDataSource;
import com.jxdinfo.hussar.core.mutidatasource.util.ChangeDatasource;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.encrypt.util.SM4Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    @Autowired
    ChangeDatasource changeDatasource;
    @Autowired
    private SysUserMapper sysUserMapper;

    @Override
    public SysUser user(String account) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_account", (Object)account);
        return (SysUser)super.getOne((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> queryTenantList(String userName, String type, String tenantId, Integer page, Integer limit) {
        HashMap<String, Object> tenantListMap = new HashMap<String, Object>(5);
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        List<SysUser> list = this.sysUserMapper.getTenantList((Page<SysUser>)pages, userName, type, tenantId);
        tenantListMap.put("count", pages.getTotal());
        tenantListMap.put("data", list);
        tenantListMap.put("code", 0);
        return tenantListMap;
    }

    @Override
    public SysUser getUserByTenantId(String tenantId) {
        ChangeDatasource changeDatasource = new ChangeDatasource();
        changeDatasource.change();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TENANT_ID", (Object)tenantId);
        queryWrapper.eq((Object)"TENANT_TYPE", (Object)"2");
        return (SysUser)super.getOne((Wrapper)queryWrapper);
    }

    @Override
    public SysUser queryTenantByTenantId(String tenantId, String tenantCipher) {
        ChangeDatasource changeDatasource = new ChangeDatasource();
        changeDatasource.change();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"tenant_id", (Object)tenantId)).eq((Object)"tenant_cipher", (Object)tenantCipher)).eq((Object)"tenant_type", (Object)"2");
        return (SysUser)super.getOne((Wrapper)queryWrapper);
    }

    @Override
    public String createDatabase(String userAccount, String url) {
        StringBuilder sb = new StringBuilder();
        String str1 = null;
        String str2 = this.sysUserMapper.getMYSQLUser(userAccount, url.split(":")[1]);
        if ("mysql".equals(url.split(":")[1])) {
            str1 = this.sysUserMapper.getDatabase(userAccount);
            sb.append("CREATE DATABASE IF NOT EXISTS ").append(userAccount).append(" default charset utf8 COLLATE utf8_general_ci;");
            sb.append("CREATE USER  '").append(userAccount).append("'@'%' IDENTIFIED BY  '").append(userAccount).append("';");
            sb.append("GRANT all privileges ON `").append(userAccount).append("`.* TO '").append(userAccount).append("'@'%';");
            sb.append("flush privileges;");
        } else if ("oracle".equals(url.split(":")[1]) || "dm".equals(url.split(":")[1])) {
            sb.append("begin execute immediate 'CREATE USER ").append(userAccount).append(" IDENTIFIED BY ").append(userAccount).append("';");
            sb.append("execute immediate 'GRANT DBA TO ").append(userAccount).append("';end;");
        }
        if (str1 != null) {
            return "\u6570\u636e\u5e93\u5df2\u5b58\u5728\uff01";
        }
        if (str2 != null) {
            return "\u6570\u636e\u5e93\u7528\u6237\u5df2\u5b58\u5728\uff01";
        }
        this.sysUserMapper.createDatabase(sb.toString());
        return null;
    }

    @Override
    public String removeDatabase(String userAccount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_account", (Object)userAccount);
        SysUser sysUser = (SysUser)this.sysUserMapper.selectOne((Wrapper)queryWrapper);
        String connectionName = SM4Util.decrypt((String)sysUser.getConnectionName(), (String)"admin#$%^kopoiuy");
        String dbName = SM4Util.decrypt((String)sysUser.getDbName(), (String)"admin#$%^kopoiuy");
        String dbType = sysUser.getDbType();
        if ("Mysql".equals(dbType)) {
            this.sysUserMapper.removeDatabaseMysql(dbName, connectionName);
        } else if ("Oracle".equals(dbType)) {
            List<Map<String, String>> list = this.sysUserMapper.getUserAccountConn(userAccount.toUpperCase());
            this.sysUserMapper.removeDatabaseOracle(list, connectionName);
        } else if ("Dm".equals(dbType)) {
            this.sysUserMapper.removeDatabaseDm(connectionName);
        }
        return null;
    }

    @Override
    public Void getModel(InputStream in, HttpServletResponse response) {
        try {
            response.addHeader("content-disposition", "attachment;filename=" + URLEncoder.encode("\u5168\u91cf\u540c\u6b65\u8868\u683c\u6a21\u677f", "utf-8"));
            ServletOutputStream out = response.getOutputStream();
            byte[] b = new byte[4096];
            int size = in.read(b);
            while (size > 0) {
                out.write(b, 0, size);
                size = in.read(b);
            }
            out.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean updateDbMessage(String state, SysUser sysUser) {
        SysUser oldSysUser = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)sysUser.getUserId()));
        String tenantId = oldSysUser.getTenantId();
        sysUser.setTenantId(tenantId);
        this.changeDatasource.changeSavedDateBase(tenantId, sysUser);
        if (this.testConn(tenantId)) {
            if ("true".equals(state)) {
                this.removeDatabase(oldSysUser.getUserAccount());
            }
            this.sysUserMapper.updateByTenantId(sysUser);
            return true;
        }
        this.changeDatasource.changeSavedDateBase(tenantId, oldSysUser);
        return false;
    }

    @Override
    public boolean testConn(String tenantId) {
        Connection conn = null;
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)SpringContextHolder.getBean(DynamicDataSource.class));
        DruidDataSource dataSource = (DruidDataSource)dynamicDataSource.getDynamicTargetDataSources().get(tenantId);
        String url = dataSource.getUrl();
        String driverClass = dataSource.getDriverClassName();
        String connectionName = dataSource.getUsername();
        String connectionPass = dataSource.getPassword();
        try {
            Class.forName(driverClass);
            conn = DriverManager.getConnection(url, connectionName, connectionPass);
            conn.setAutoCommit(false);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public int deleteUser(String userId) {
        return this.sysUserMapper.deleteUser(userId);
    }
}

