/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.rabbitmq.synchronization.impl;

import com.jxdinfo.hussar.bsp.rabbitmq.service.IHussarBpmOrganService;
import com.jxdinfo.hussar.bsp.rabbitmq.service.IHussarBpmRoleService;
import com.jxdinfo.hussar.bsp.rabbitmq.service.IHussarBpmUserRoleService;
import com.jxdinfo.hussar.bsp.rabbitmq.synchronization.ISynchronizationService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SynchronizationServiceImpl
implements ISynchronizationService {
    @Autowired
    IHussarBpmOrganService hussarBpmOrganService;
    @Autowired
    IHussarBpmRoleService hussarBpmRoleService;
    @Autowired
    IHussarBpmUserRoleService hussarBpmUserRoleService;
    private static final String HUSSAR_BPM_ORGAN = "hussarBpmOrgan";
    private static final String HUSSAR_BPM_ROLE = "hussarBpmRole";
    private static final String HUSSAR_BPM_USER_ROLE = "hussarBpmUserRole";

    @Override
    public int synchronization(MultipartFile modelFile) {
        ArrayList userRole;
        List role;
        Map<String, Object> datas = this.getDatas(modelFile);
        int allNum = 0;
        List organ = (List)datas.get(HUSSAR_BPM_ORGAN);
        HashSet set = new HashSet();
        List maps = (List)datas.get(HUSSAR_BPM_ORGAN);
        if (ToolUtil.isNotEmpty((Object)organ)) {
            for (int i = maps.size() - 1; i >= 0; --i) {
                int num = set.size();
                set.add(((Map)maps.get(i)).get("organId"));
                if (num != set.size()) continue;
                organ.remove(i);
            }
            allNum += organ.size();
            this.hussarBpmOrganService.deleteAll();
            this.hussarBpmOrganService.saveBatch(organ);
        }
        if (ToolUtil.isNotEmpty((Object)(role = (List)datas.get(HUSSAR_BPM_ROLE)))) {
            set = new HashSet();
            maps = (List)datas.get(HUSSAR_BPM_ROLE);
            for (int i = maps.size() - 1; i >= 0; --i) {
                int num = set.size();
                set.add(((Map)maps.get(i)).get("roleId"));
                if (num != set.size()) continue;
                role.remove(i);
            }
            allNum += role.size();
            this.hussarBpmRoleService.deleteAll();
            this.hussarBpmRoleService.saveBatch(role);
        }
        if (ToolUtil.isNotEmpty((Object)(userRole = (ArrayList)datas.get(HUSSAR_BPM_USER_ROLE)))) {
            allNum += userRole.size();
            userRole = new ArrayList(new HashSet(userRole));
            this.hussarBpmUserRoleService.deleteAll();
            this.hussarBpmUserRoleService.saveBatch(userRole);
        }
        return allNum;
    }

    private Map<String, Object> getDatas(MultipartFile modelFile) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        try {
            InputStream fis = modelFile.getInputStream();
            Workbook wb = WorkbookFactory.create((InputStream)fis);
            int sheetNum = wb.getNumberOfSheets();
            for (int i = 0; i < sheetNum; ++i) {
                Sheet sheet = wb.getSheetAt(i);
                LinkedList data = new LinkedList();
                List<Object> names = new LinkedList();
                names = wb.getSheetName(i).equals(HUSSAR_BPM_ORGAN) ? Arrays.asList("organId", "organCode", "organName", "parentId", "type", "sort", "state", "wechat", "email", "mobile") : (wb.getSheetName(i).equals(HUSSAR_BPM_ROLE) ? Arrays.asList("roleId", "roleName", "parentId", "sort", "type") : (wb.getSheetName(i).equals(HUSSAR_BPM_USER_ROLE) ? Arrays.asList("userId", "grantedRole") : new ArrayList()));
                int rowNum = sheet.getPhysicalNumberOfRows();
                for (int j = 1; j < rowNum; ++j) {
                    HashMap<Object, String> map = new HashMap<Object, String>();
                    Row row = sheet.getRow(j);
                    if (row == null || ToolUtil.isEmpty((Object)this.getCellValue(row.getCell(0)))) continue;
                    for (int m = 0; m < names.size(); ++m) {
                        if (m == 3 && wb.getSheetName(i).equals(HUSSAR_BPM_ROLE) && ToolUtil.isEmpty((Object)this.getCellValue(row.getCell(m)))) {
                            map.put(names.get(m), "0");
                            continue;
                        }
                        map.put(names.get(m), this.getCellValue(row.getCell(m)));
                    }
                    data.add(map);
                }
                datas.put(wb.getSheetName(i), data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datas;
    }

    private String getCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        cellValue = cell.getCellType() == 0 ? String.valueOf((long)cell.getNumericCellValue()) : cell.getRichStringCellValue().getString();
        return cellValue;
    }
}

